/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.OperationType;
import com.amazonaws.services.ec2.model.transform.ModifyImageAttributeRequestMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyImageAttributeRequest> {
    private String imageId;
    private String attribute;
    private String operationType;
    private SdkInternalList<String> userIds;
    private SdkInternalList<String> userGroups;
    private SdkInternalList<String> productCodes;
    private String value;
    private LaunchPermissionModifications launchPermission;
    private String description;

    public ModifyImageAttributeRequest() {
    }

    public ModifyImageAttributeRequest(String imageId, String attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute);
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public ModifyImageAttributeRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ModifyImageAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public ModifyImageAttributeRequest withOperationType(String operationType) {
        this.setOperationType(operationType);
        return this;
    }

    @JsonIgnore
    public void setOperationType(OperationType operationType) {
        this.operationType = operationType.toString();
    }

    public ModifyImageAttributeRequest withOperationType(OperationType operationType) {
        this.setOperationType(operationType);
        return this;
    }

    public List<String> getUserIds() {
        if (this.userIds == null) {
            this.userIds = new SdkInternalList();
        }
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new SdkInternalList<String>(userIds);
    }

    public ModifyImageAttributeRequest withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds(new SdkInternalList<String>(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add(ele);
        }
        return this;
    }

    public ModifyImageAttributeRequest withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public List<String> getUserGroups() {
        if (this.userGroups == null) {
            this.userGroups = new SdkInternalList();
        }
        return this.userGroups;
    }

    public void setUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
            return;
        }
        this.userGroups = new SdkInternalList<String>(userGroups);
    }

    public ModifyImageAttributeRequest withUserGroups(String ... userGroups) {
        if (this.userGroups == null) {
            this.setUserGroups(new SdkInternalList<String>(userGroups.length));
        }
        for (String ele : userGroups) {
            this.userGroups.add(ele);
        }
        return this;
    }

    public ModifyImageAttributeRequest withUserGroups(Collection<String> userGroups) {
        this.setUserGroups(userGroups);
        return this;
    }

    public List<String> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new SdkInternalList();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<String> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        this.productCodes = new SdkInternalList<String>(productCodes);
    }

    public ModifyImageAttributeRequest withProductCodes(String ... productCodes) {
        if (this.productCodes == null) {
            this.setProductCodes(new SdkInternalList<String>(productCodes.length));
        }
        for (String ele : productCodes) {
            this.productCodes.add(ele);
        }
        return this;
    }

    public ModifyImageAttributeRequest withProductCodes(Collection<String> productCodes) {
        this.setProductCodes(productCodes);
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ModifyImageAttributeRequest withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setLaunchPermission(LaunchPermissionModifications launchPermission) {
        this.launchPermission = launchPermission;
    }

    public LaunchPermissionModifications getLaunchPermission() {
        return this.launchPermission;
    }

    public ModifyImageAttributeRequest withLaunchPermission(LaunchPermissionModifications launchPermission) {
        this.setLaunchPermission(launchPermission);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModifyImageAttributeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public Request<ModifyImageAttributeRequest> getDryRunRequest() {
        Request<ModifyImageAttributeRequest> request = new ModifyImageAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getOperationType() != null) {
            sb.append("OperationType: ").append(this.getOperationType()).append(",");
        }
        if (this.getUserIds() != null) {
            sb.append("UserIds: ").append(this.getUserIds()).append(",");
        }
        if (this.getUserGroups() != null) {
            sb.append("UserGroups: ").append(this.getUserGroups()).append(",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: ").append(this.getProductCodes()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getLaunchPermission() != null) {
            sb.append("LaunchPermission: ").append(this.getLaunchPermission()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperationType() == null ^ this.getOperationType() == null) {
            return false;
        }
        if (other.getOperationType() != null && !other.getOperationType().equals(this.getOperationType())) {
            return false;
        }
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getUserGroups() == null ^ this.getUserGroups() == null) {
            return false;
        }
        if (other.getUserGroups() != null && !other.getUserGroups().equals(this.getUserGroups())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getLaunchPermission() == null ^ this.getLaunchPermission() == null) {
            return false;
        }
        if (other.getLaunchPermission() != null && !other.getLaunchPermission().equals(this.getLaunchPermission())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperationType() == null ? 0 : this.getOperationType().hashCode());
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroups() == null ? 0 : this.getUserGroups().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPermission() == null ? 0 : this.getLaunchPermission().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    @Override
    public ModifyImageAttributeRequest clone() {
        return (ModifyImageAttributeRequest)super.clone();
    }
}

