/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.braket.model.transform;

import com.amazonaws.services.braket.model.S3DataSource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3DataSourceJsonUnmarshaller
implements Unmarshaller<S3DataSource, JsonUnmarshallerContext> {
    private static S3DataSourceJsonUnmarshaller instance;

    public S3DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3DataSource s3DataSource = new S3DataSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("s3Uri", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3DataSource.setS3Uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3DataSource;
    }

    public static S3DataSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3DataSourceJsonUnmarshaller();
        }
        return instance;
    }
}

