/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.DocumentBlock;

@SdkInternalApi
public class DocumentBlockMarshaller {
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final DocumentBlockMarshaller instance = new DocumentBlockMarshaller();

    public static DocumentBlockMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentBlock documentBlock, ProtocolMarshaller protocolMarshaller) {
        if (documentBlock == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentBlock.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)documentBlock.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentBlock.getSource(), SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

