/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The tokens used in a message API inference call.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/TokenUsage" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TokenUsage implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The number of tokens sent in the request to the model.
     * </p>
     */
    private Integer inputTokens;
    /**
     * <p>
     * The number of tokens that the model generated for the request.
     * </p>
     */
    private Integer outputTokens;
    /**
     * <p>
     * The total of input tokens and tokens generated by the model.
     * </p>
     */
    private Integer totalTokens;

    /**
     * <p>
     * The number of tokens sent in the request to the model.
     * </p>
     * 
     * @param inputTokens
     *        The number of tokens sent in the request to the model.
     */

    public void setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
    }

    /**
     * <p>
     * The number of tokens sent in the request to the model.
     * </p>
     * 
     * @return The number of tokens sent in the request to the model.
     */

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    /**
     * <p>
     * The number of tokens sent in the request to the model.
     * </p>
     * 
     * @param inputTokens
     *        The number of tokens sent in the request to the model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TokenUsage withInputTokens(Integer inputTokens) {
        setInputTokens(inputTokens);
        return this;
    }

    /**
     * <p>
     * The number of tokens that the model generated for the request.
     * </p>
     * 
     * @param outputTokens
     *        The number of tokens that the model generated for the request.
     */

    public void setOutputTokens(Integer outputTokens) {
        this.outputTokens = outputTokens;
    }

    /**
     * <p>
     * The number of tokens that the model generated for the request.
     * </p>
     * 
     * @return The number of tokens that the model generated for the request.
     */

    public Integer getOutputTokens() {
        return this.outputTokens;
    }

    /**
     * <p>
     * The number of tokens that the model generated for the request.
     * </p>
     * 
     * @param outputTokens
     *        The number of tokens that the model generated for the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TokenUsage withOutputTokens(Integer outputTokens) {
        setOutputTokens(outputTokens);
        return this;
    }

    /**
     * <p>
     * The total of input tokens and tokens generated by the model.
     * </p>
     * 
     * @param totalTokens
     *        The total of input tokens and tokens generated by the model.
     */

    public void setTotalTokens(Integer totalTokens) {
        this.totalTokens = totalTokens;
    }

    /**
     * <p>
     * The total of input tokens and tokens generated by the model.
     * </p>
     * 
     * @return The total of input tokens and tokens generated by the model.
     */

    public Integer getTotalTokens() {
        return this.totalTokens;
    }

    /**
     * <p>
     * The total of input tokens and tokens generated by the model.
     * </p>
     * 
     * @param totalTokens
     *        The total of input tokens and tokens generated by the model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TokenUsage withTotalTokens(Integer totalTokens) {
        setTotalTokens(totalTokens);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInputTokens() != null)
            sb.append("InputTokens: ").append(getInputTokens()).append(",");
        if (getOutputTokens() != null)
            sb.append("OutputTokens: ").append(getOutputTokens()).append(",");
        if (getTotalTokens() != null)
            sb.append("TotalTokens: ").append(getTotalTokens());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TokenUsage == false)
            return false;
        TokenUsage other = (TokenUsage) obj;
        if (other.getInputTokens() == null ^ this.getInputTokens() == null)
            return false;
        if (other.getInputTokens() != null && other.getInputTokens().equals(this.getInputTokens()) == false)
            return false;
        if (other.getOutputTokens() == null ^ this.getOutputTokens() == null)
            return false;
        if (other.getOutputTokens() != null && other.getOutputTokens().equals(this.getOutputTokens()) == false)
            return false;
        if (other.getTotalTokens() == null ^ this.getTotalTokens() == null)
            return false;
        if (other.getTotalTokens() != null && other.getTotalTokens().equals(this.getTotalTokens()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInputTokens() == null) ? 0 : getInputTokens().hashCode());
        hashCode = prime * hashCode + ((getOutputTokens() == null) ? 0 : getOutputTokens().hashCode());
        hashCode = prime * hashCode + ((getTotalTokens() == null) ? 0 : getTotalTokens().hashCode());
        return hashCode;
    }

    @Override
    public TokenUsage clone() {
        try {
            return (TokenUsage) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.TokenUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
