/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrockagent.model.PromptVariant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreatePromptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String customerEncryptionKeyArn;
    private String defaultVariant;
    private String description;
    private String name;
    private Map<String, String> tags;
    private List<PromptVariant> variants;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePromptRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
        this.customerEncryptionKeyArn = customerEncryptionKeyArn;
    }

    public String getCustomerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public CreatePromptRequest withCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
        this.setCustomerEncryptionKeyArn(customerEncryptionKeyArn);
        return this;
    }

    public void setDefaultVariant(String defaultVariant) {
        this.defaultVariant = defaultVariant;
    }

    public String getDefaultVariant() {
        return this.defaultVariant;
    }

    public CreatePromptRequest withDefaultVariant(String defaultVariant) {
        this.setDefaultVariant(defaultVariant);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePromptRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreatePromptRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreatePromptRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreatePromptRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreatePromptRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<PromptVariant> getVariants() {
        return this.variants;
    }

    public void setVariants(Collection<PromptVariant> variants) {
        if (variants == null) {
            this.variants = null;
            return;
        }
        this.variants = new ArrayList<PromptVariant>(variants);
    }

    public CreatePromptRequest withVariants(PromptVariant ... variants) {
        if (this.variants == null) {
            this.setVariants(new ArrayList<PromptVariant>(variants.length));
        }
        for (PromptVariant ele : variants) {
            this.variants.add(ele);
        }
        return this;
    }

    public CreatePromptRequest withVariants(Collection<PromptVariant> variants) {
        this.setVariants(variants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getCustomerEncryptionKeyArn() != null) {
            sb.append("CustomerEncryptionKeyArn: ").append(this.getCustomerEncryptionKeyArn()).append(",");
        }
        if (this.getDefaultVariant() != null) {
            sb.append("DefaultVariant: ").append(this.getDefaultVariant()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVariants() != null) {
            sb.append("Variants: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptRequest)) {
            return false;
        }
        CreatePromptRequest other = (CreatePromptRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getCustomerEncryptionKeyArn() == null ^ this.getCustomerEncryptionKeyArn() == null) {
            return false;
        }
        if (other.getCustomerEncryptionKeyArn() != null && !other.getCustomerEncryptionKeyArn().equals(this.getCustomerEncryptionKeyArn())) {
            return false;
        }
        if (other.getDefaultVariant() == null ^ this.getDefaultVariant() == null) {
            return false;
        }
        if (other.getDefaultVariant() != null && !other.getDefaultVariant().equals(this.getDefaultVariant())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVariants() == null ^ this.getVariants() == null) {
            return false;
        }
        return other.getVariants() == null || other.getVariants().equals(this.getVariants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerEncryptionKeyArn() == null ? 0 : this.getCustomerEncryptionKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVariant() == null ? 0 : this.getDefaultVariant().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVariants() == null ? 0 : this.getVariants().hashCode());
        return hashCode;
    }

    public CreatePromptRequest clone() {
        return (CreatePromptRequest)super.clone();
    }
}

