/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.EvaluationJobStatus;
import com.amazonaws.services.bedrock.model.EvaluationJobType;
import com.amazonaws.services.bedrock.model.EvaluationTaskType;
import com.amazonaws.services.bedrock.model.transform.EvaluationSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class EvaluationSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobArn;
    private String jobName;
    private String status;
    private Date creationTime;
    private String jobType;
    private List<String> evaluationTaskTypes;
    private List<String> modelIdentifiers;

    public void setJobArn(String jobArn) {
        this.jobArn = jobArn;
    }

    public String getJobArn() {
        return this.jobArn;
    }

    public EvaluationSummary withJobArn(String jobArn) {
        this.setJobArn(jobArn);
        return this;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public EvaluationSummary withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public EvaluationSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public EvaluationSummary withStatus(EvaluationJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public EvaluationSummary withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobType() {
        return this.jobType;
    }

    public EvaluationSummary withJobType(String jobType) {
        this.setJobType(jobType);
        return this;
    }

    public EvaluationSummary withJobType(EvaluationJobType jobType) {
        this.jobType = jobType.toString();
        return this;
    }

    public List<String> getEvaluationTaskTypes() {
        return this.evaluationTaskTypes;
    }

    public void setEvaluationTaskTypes(Collection<String> evaluationTaskTypes) {
        if (evaluationTaskTypes == null) {
            this.evaluationTaskTypes = null;
            return;
        }
        this.evaluationTaskTypes = new ArrayList<String>(evaluationTaskTypes);
    }

    public EvaluationSummary withEvaluationTaskTypes(String ... evaluationTaskTypes) {
        if (this.evaluationTaskTypes == null) {
            this.setEvaluationTaskTypes(new ArrayList<String>(evaluationTaskTypes.length));
        }
        for (String ele : evaluationTaskTypes) {
            this.evaluationTaskTypes.add(ele);
        }
        return this;
    }

    public EvaluationSummary withEvaluationTaskTypes(Collection<String> evaluationTaskTypes) {
        this.setEvaluationTaskTypes(evaluationTaskTypes);
        return this;
    }

    public EvaluationSummary withEvaluationTaskTypes(EvaluationTaskType ... evaluationTaskTypes) {
        ArrayList<String> evaluationTaskTypesCopy = new ArrayList<String>(evaluationTaskTypes.length);
        for (EvaluationTaskType value : evaluationTaskTypes) {
            evaluationTaskTypesCopy.add(value.toString());
        }
        if (this.getEvaluationTaskTypes() == null) {
            this.setEvaluationTaskTypes(evaluationTaskTypesCopy);
        } else {
            this.getEvaluationTaskTypes().addAll(evaluationTaskTypesCopy);
        }
        return this;
    }

    public List<String> getModelIdentifiers() {
        return this.modelIdentifiers;
    }

    public void setModelIdentifiers(Collection<String> modelIdentifiers) {
        if (modelIdentifiers == null) {
            this.modelIdentifiers = null;
            return;
        }
        this.modelIdentifiers = new ArrayList<String>(modelIdentifiers);
    }

    public EvaluationSummary withModelIdentifiers(String ... modelIdentifiers) {
        if (this.modelIdentifiers == null) {
            this.setModelIdentifiers(new ArrayList<String>(modelIdentifiers.length));
        }
        for (String ele : modelIdentifiers) {
            this.modelIdentifiers.add(ele);
        }
        return this;
    }

    public EvaluationSummary withModelIdentifiers(Collection<String> modelIdentifiers) {
        this.setModelIdentifiers(modelIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobArn() != null) {
            sb.append("JobArn: ").append(this.getJobArn()).append(",");
        }
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getJobType() != null) {
            sb.append("JobType: ").append(this.getJobType()).append(",");
        }
        if (this.getEvaluationTaskTypes() != null) {
            sb.append("EvaluationTaskTypes: ").append(this.getEvaluationTaskTypes()).append(",");
        }
        if (this.getModelIdentifiers() != null) {
            sb.append("ModelIdentifiers: ").append(this.getModelIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSummary)) {
            return false;
        }
        EvaluationSummary other = (EvaluationSummary)obj;
        if (other.getJobArn() == null ^ this.getJobArn() == null) {
            return false;
        }
        if (other.getJobArn() != null && !other.getJobArn().equals(this.getJobArn())) {
            return false;
        }
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getJobType() == null ^ this.getJobType() == null) {
            return false;
        }
        if (other.getJobType() != null && !other.getJobType().equals(this.getJobType())) {
            return false;
        }
        if (other.getEvaluationTaskTypes() == null ^ this.getEvaluationTaskTypes() == null) {
            return false;
        }
        if (other.getEvaluationTaskTypes() != null && !other.getEvaluationTaskTypes().equals(this.getEvaluationTaskTypes())) {
            return false;
        }
        if (other.getModelIdentifiers() == null ^ this.getModelIdentifiers() == null) {
            return false;
        }
        return other.getModelIdentifiers() == null || other.getModelIdentifiers().equals(this.getModelIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobArn() == null ? 0 : this.getJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getJobType() == null ? 0 : this.getJobType().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationTaskTypes() == null ? 0 : this.getEvaluationTaskTypes().hashCode());
        hashCode = 31 * hashCode + (this.getModelIdentifiers() == null ? 0 : this.getModelIdentifiers().hashCode());
        return hashCode;
    }

    public EvaluationSummary clone() {
        try {
            return (EvaluationSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

