/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.EvaluationDataset;
import com.amazonaws.services.bedrock.model.EvaluationTaskType;
import com.amazonaws.services.bedrock.model.transform.EvaluationDatasetMetricConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluationDatasetMetricConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String taskType;
    private EvaluationDataset dataset;
    private List<String> metricNames;

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public EvaluationDatasetMetricConfig withTaskType(String taskType) {
        this.setTaskType(taskType);
        return this;
    }

    public EvaluationDatasetMetricConfig withTaskType(EvaluationTaskType taskType) {
        this.taskType = taskType.toString();
        return this;
    }

    public void setDataset(EvaluationDataset dataset) {
        this.dataset = dataset;
    }

    public EvaluationDataset getDataset() {
        return this.dataset;
    }

    public EvaluationDatasetMetricConfig withDataset(EvaluationDataset dataset) {
        this.setDataset(dataset);
        return this;
    }

    public List<String> getMetricNames() {
        return this.metricNames;
    }

    public void setMetricNames(Collection<String> metricNames) {
        if (metricNames == null) {
            this.metricNames = null;
            return;
        }
        this.metricNames = new ArrayList<String>(metricNames);
    }

    public EvaluationDatasetMetricConfig withMetricNames(String ... metricNames) {
        if (this.metricNames == null) {
            this.setMetricNames(new ArrayList<String>(metricNames.length));
        }
        for (String ele : metricNames) {
            this.metricNames.add(ele);
        }
        return this;
    }

    public EvaluationDatasetMetricConfig withMetricNames(Collection<String> metricNames) {
        this.setMetricNames(metricNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskType() != null) {
            sb.append("TaskType: ").append(this.getTaskType()).append(",");
        }
        if (this.getDataset() != null) {
            sb.append("Dataset: ").append(this.getDataset()).append(",");
        }
        if (this.getMetricNames() != null) {
            sb.append("MetricNames: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationDatasetMetricConfig)) {
            return false;
        }
        EvaluationDatasetMetricConfig other = (EvaluationDatasetMetricConfig)obj;
        if (other.getTaskType() == null ^ this.getTaskType() == null) {
            return false;
        }
        if (other.getTaskType() != null && !other.getTaskType().equals(this.getTaskType())) {
            return false;
        }
        if (other.getDataset() == null ^ this.getDataset() == null) {
            return false;
        }
        if (other.getDataset() != null && !other.getDataset().equals(this.getDataset())) {
            return false;
        }
        if (other.getMetricNames() == null ^ this.getMetricNames() == null) {
            return false;
        }
        return other.getMetricNames() == null || other.getMetricNames().equals(this.getMetricNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskType() == null ? 0 : this.getTaskType().hashCode());
        hashCode = 31 * hashCode + (this.getDataset() == null ? 0 : this.getDataset().hashCode());
        hashCode = 31 * hashCode + (this.getMetricNames() == null ? 0 : this.getMetricNames().hashCode());
        return hashCode;
    }

    public EvaluationDatasetMetricConfig clone() {
        try {
            return (EvaluationDatasetMetricConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationDatasetMetricConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

