/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.GuardrailTopicType;
import com.amazonaws.services.bedrock.model.transform.GuardrailTopicConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuardrailTopicConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String definition;
    private List<String> examples;
    private String type;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GuardrailTopicConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public GuardrailTopicConfig withDefinition(String definition) {
        this.setDefinition(definition);
        return this;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public void setExamples(Collection<String> examples) {
        if (examples == null) {
            this.examples = null;
            return;
        }
        this.examples = new ArrayList<String>(examples);
    }

    public GuardrailTopicConfig withExamples(String ... examples) {
        if (this.examples == null) {
            this.setExamples(new ArrayList<String>(examples.length));
        }
        for (String ele : examples) {
            this.examples.add(ele);
        }
        return this;
    }

    public GuardrailTopicConfig withExamples(Collection<String> examples) {
        this.setExamples(examples);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public GuardrailTopicConfig withType(String type) {
        this.setType(type);
        return this;
    }

    public GuardrailTopicConfig withType(GuardrailTopicType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExamples() != null) {
            sb.append("Examples: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicConfig)) {
            return false;
        }
        GuardrailTopicConfig other = (GuardrailTopicConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getExamples() == null ^ this.getExamples() == null) {
            return false;
        }
        if (other.getExamples() != null && !other.getExamples().equals(this.getExamples())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getExamples() == null ? 0 : this.getExamples().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public GuardrailTopicConfig clone() {
        try {
            return (GuardrailTopicConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GuardrailTopicConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

