/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.Validator;
import com.amazonaws.services.bedrock.model.transform.ValidationDataConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidationDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Validator> validators;

    public List<Validator> getValidators() {
        return this.validators;
    }

    public void setValidators(Collection<Validator> validators) {
        if (validators == null) {
            this.validators = null;
            return;
        }
        this.validators = new ArrayList<Validator>(validators);
    }

    public ValidationDataConfig withValidators(Validator ... validators) {
        if (this.validators == null) {
            this.setValidators(new ArrayList<Validator>(validators.length));
        }
        for (Validator ele : validators) {
            this.validators.add(ele);
        }
        return this;
    }

    public ValidationDataConfig withValidators(Collection<Validator> validators) {
        this.setValidators(validators);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValidators() != null) {
            sb.append("Validators: ").append(this.getValidators());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationDataConfig)) {
            return false;
        }
        ValidationDataConfig other = (ValidationDataConfig)obj;
        if (other.getValidators() == null ^ this.getValidators() == null) {
            return false;
        }
        return other.getValidators() == null || other.getValidators().equals(this.getValidators());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValidators() == null ? 0 : this.getValidators().hashCode());
        return hashCode;
    }

    public ValidationDataConfig clone() {
        try {
            return (ValidationDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

