/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.batch.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.batch.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * EksContainerSecurityContext JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EksContainerSecurityContextJsonUnmarshaller implements Unmarshaller<EksContainerSecurityContext, JsonUnmarshallerContext> {

    public EksContainerSecurityContext unmarshall(JsonUnmarshallerContext context) throws Exception {
        EksContainerSecurityContext eksContainerSecurityContext = new EksContainerSecurityContext();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("runAsUser", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setRunAsUser(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("runAsGroup", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setRunAsGroup(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("privileged", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setPrivileged(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("allowPrivilegeEscalation", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setAllowPrivilegeEscalation(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("readOnlyRootFilesystem", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setReadOnlyRootFilesystem(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("runAsNonRoot", targetDepth)) {
                    context.nextToken();
                    eksContainerSecurityContext.setRunAsNonRoot(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return eksContainerSecurityContext;
    }

    private static EksContainerSecurityContextJsonUnmarshaller instance;

    public static EksContainerSecurityContextJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new EksContainerSecurityContextJsonUnmarshaller();
        return instance;
    }
}
