/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.NodeRangeProperty;
import com.amazonaws.services.batch.model.transform.NodePropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer numNodes;
    private Integer mainNode;
    private List<NodeRangeProperty> nodeRangeProperties;

    public void setNumNodes(Integer numNodes) {
        this.numNodes = numNodes;
    }

    public Integer getNumNodes() {
        return this.numNodes;
    }

    public NodeProperties withNumNodes(Integer numNodes) {
        this.setNumNodes(numNodes);
        return this;
    }

    public void setMainNode(Integer mainNode) {
        this.mainNode = mainNode;
    }

    public Integer getMainNode() {
        return this.mainNode;
    }

    public NodeProperties withMainNode(Integer mainNode) {
        this.setMainNode(mainNode);
        return this;
    }

    public List<NodeRangeProperty> getNodeRangeProperties() {
        return this.nodeRangeProperties;
    }

    public void setNodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties) {
        if (nodeRangeProperties == null) {
            this.nodeRangeProperties = null;
            return;
        }
        this.nodeRangeProperties = new ArrayList<NodeRangeProperty>(nodeRangeProperties);
    }

    public NodeProperties withNodeRangeProperties(NodeRangeProperty ... nodeRangeProperties) {
        if (this.nodeRangeProperties == null) {
            this.setNodeRangeProperties(new ArrayList<NodeRangeProperty>(nodeRangeProperties.length));
        }
        for (NodeRangeProperty ele : nodeRangeProperties) {
            this.nodeRangeProperties.add(ele);
        }
        return this;
    }

    public NodeProperties withNodeRangeProperties(Collection<NodeRangeProperty> nodeRangeProperties) {
        this.setNodeRangeProperties(nodeRangeProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumNodes() != null) {
            sb.append("NumNodes: ").append(this.getNumNodes()).append(",");
        }
        if (this.getMainNode() != null) {
            sb.append("MainNode: ").append(this.getMainNode()).append(",");
        }
        if (this.getNodeRangeProperties() != null) {
            sb.append("NodeRangeProperties: ").append(this.getNodeRangeProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeProperties)) {
            return false;
        }
        NodeProperties other = (NodeProperties)obj;
        if (other.getNumNodes() == null ^ this.getNumNodes() == null) {
            return false;
        }
        if (other.getNumNodes() != null && !other.getNumNodes().equals(this.getNumNodes())) {
            return false;
        }
        if (other.getMainNode() == null ^ this.getMainNode() == null) {
            return false;
        }
        if (other.getMainNode() != null && !other.getMainNode().equals(this.getMainNode())) {
            return false;
        }
        if (other.getNodeRangeProperties() == null ^ this.getNodeRangeProperties() == null) {
            return false;
        }
        return other.getNodeRangeProperties() == null || other.getNodeRangeProperties().equals(this.getNodeRangeProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumNodes() == null ? 0 : this.getNumNodes().hashCode());
        hashCode = 31 * hashCode + (this.getMainNode() == null ? 0 : this.getMainNode().hashCode());
        hashCode = 31 * hashCode + (this.getNodeRangeProperties() == null ? 0 : this.getNodeRangeProperties().hashCode());
        return hashCode;
    }

    public NodeProperties clone() {
        try {
            return (NodeProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

