/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backupgateway.model.Hypervisor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListHypervisorsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Hypervisor> hypervisors;
    private String nextToken;

    public List<Hypervisor> getHypervisors() {
        return this.hypervisors;
    }

    public void setHypervisors(Collection<Hypervisor> hypervisors) {
        if (hypervisors == null) {
            this.hypervisors = null;
            return;
        }
        this.hypervisors = new ArrayList<Hypervisor>(hypervisors);
    }

    public ListHypervisorsResult withHypervisors(Hypervisor ... hypervisors) {
        if (this.hypervisors == null) {
            this.setHypervisors(new ArrayList<Hypervisor>(hypervisors.length));
        }
        for (Hypervisor ele : hypervisors) {
            this.hypervisors.add(ele);
        }
        return this;
    }

    public ListHypervisorsResult withHypervisors(Collection<Hypervisor> hypervisors) {
        this.setHypervisors(hypervisors);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListHypervisorsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHypervisors() != null) {
            sb.append("Hypervisors: ").append(this.getHypervisors()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHypervisorsResult)) {
            return false;
        }
        ListHypervisorsResult other = (ListHypervisorsResult)obj;
        if (other.getHypervisors() == null ^ this.getHypervisors() == null) {
            return false;
        }
        if (other.getHypervisors() != null && !other.getHypervisors().equals(this.getHypervisors())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHypervisors() == null ? 0 : this.getHypervisors().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListHypervisorsResult clone() {
        try {
            return (ListHypervisorsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

