/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListTransformersResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     */
    private java.util.List<TransformerSummary> transformers;
    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     * 
     * @return Returns an array of one or more transformer objects.</p>
     *         <p>
     *         For each transformer, a <code>TransformerSummary</code> object is returned. The
     *         <code>TransformerSummary</code> contains all the details for a specific transformer.
     */

    public java.util.List<TransformerSummary> getTransformers() {
        return transformers;
    }

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     * 
     * @param transformers
     *        Returns an array of one or more transformer objects.</p>
     *        <p>
     *        For each transformer, a <code>TransformerSummary</code> object is returned. The
     *        <code>TransformerSummary</code> contains all the details for a specific transformer.
     */

    public void setTransformers(java.util.Collection<TransformerSummary> transformers) {
        if (transformers == null) {
            this.transformers = null;
            return;
        }

        this.transformers = new java.util.ArrayList<TransformerSummary>(transformers);
    }

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTransformers(java.util.Collection)} or {@link #withTransformers(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param transformers
     *        Returns an array of one or more transformer objects.</p>
     *        <p>
     *        For each transformer, a <code>TransformerSummary</code> object is returned. The
     *        <code>TransformerSummary</code> contains all the details for a specific transformer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTransformersResult withTransformers(TransformerSummary... transformers) {
        if (this.transformers == null) {
            setTransformers(new java.util.ArrayList<TransformerSummary>(transformers.length));
        }
        for (TransformerSummary ele : transformers) {
            this.transformers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     * 
     * @param transformers
     *        Returns an array of one or more transformer objects.</p>
     *        <p>
     *        For each transformer, a <code>TransformerSummary</code> object is returned. The
     *        <code>TransformerSummary</code> contains all the details for a specific transformer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTransformersResult withTransformers(java.util.Collection<TransformerSummary> transformers) {
        setTransformers(transformers);
        return this;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @param nextToken
     *        When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *        the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *        listing additional resources.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @return When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *         the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *         listing additional resources.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @param nextToken
     *        When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *        the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *        listing additional resources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTransformersResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransformers() != null)
            sb.append("Transformers: ").append(getTransformers()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListTransformersResult == false)
            return false;
        ListTransformersResult other = (ListTransformersResult) obj;
        if (other.getTransformers() == null ^ this.getTransformers() == null)
            return false;
        if (other.getTransformers() != null && other.getTransformers().equals(this.getTransformers()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransformers() == null) ? 0 : getTransformers().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListTransformersResult clone() {
        try {
            return (ListTransformersResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
