/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.autoscalingplans.AWSAutoScalingPlans;
import com.amazonaws.services.autoscalingplans.AWSAutoScalingPlansClientBuilder;
import com.amazonaws.services.autoscalingplans.model.AWSAutoScalingPlansException;
import com.amazonaws.services.autoscalingplans.model.CreateScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.CreateScalingPlanResult;
import com.amazonaws.services.autoscalingplans.model.DeleteScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.DeleteScalingPlanResult;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlanResourcesResult;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlansRequest;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlansResult;
import com.amazonaws.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest;
import com.amazonaws.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResult;
import com.amazonaws.services.autoscalingplans.model.UpdateScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.UpdateScalingPlanResult;
import com.amazonaws.services.autoscalingplans.model.transform.ConcurrentUpdateExceptionUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.CreateScalingPlanRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.CreateScalingPlanResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DeleteScalingPlanRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DeleteScalingPlanResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DescribeScalingPlanResourcesRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DescribeScalingPlanResourcesResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DescribeScalingPlansRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.DescribeScalingPlansResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.GetScalingPlanResourceForecastDataRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.GetScalingPlanResourceForecastDataResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.ObjectNotFoundExceptionUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.UpdateScalingPlanRequestProtocolMarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.UpdateScalingPlanResultJsonUnmarshaller;
import com.amazonaws.services.autoscalingplans.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSAutoScalingPlansClient
extends AmazonWebServiceClient
implements AWSAutoScalingPlans {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAutoScalingPlans.class);
    private static final String DEFAULT_SIGNING_NAME = "autoscaling-plans";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ObjectNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ObjectNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentUpdateException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentUpdateExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSAutoScalingPlansException.class));

    public static AWSAutoScalingPlansClientBuilder builder() {
        return AWSAutoScalingPlansClientBuilder.standard();
    }

    AWSAutoScalingPlansClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSAutoScalingPlansClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("autoscaling.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/autoscalingplans/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/autoscalingplans/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateScalingPlanResult createScalingPlan(CreateScalingPlanRequest request) {
        request = (CreateScalingPlanRequest)this.beforeClientExecution(request);
        return this.executeCreateScalingPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateScalingPlanResult executeCreateScalingPlan(CreateScalingPlanRequest createScalingPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createScalingPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateScalingPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateScalingPlanRequestProtocolMarshaller(protocolFactory).marshall((CreateScalingPlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)createScalingPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateScalingPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateScalingPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateScalingPlanResult createScalingPlanResult = (CreateScalingPlanResult)response.getAwsResponse();
            return createScalingPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteScalingPlanResult deleteScalingPlan(DeleteScalingPlanRequest request) {
        request = (DeleteScalingPlanRequest)this.beforeClientExecution(request);
        return this.executeDeleteScalingPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteScalingPlanResult executeDeleteScalingPlan(DeleteScalingPlanRequest deleteScalingPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScalingPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScalingPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScalingPlanRequestProtocolMarshaller(protocolFactory).marshall((DeleteScalingPlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScalingPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteScalingPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteScalingPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteScalingPlanResult deleteScalingPlanResult = (DeleteScalingPlanResult)response.getAwsResponse();
            return deleteScalingPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScalingPlanResourcesResult describeScalingPlanResources(DescribeScalingPlanResourcesRequest request) {
        request = (DescribeScalingPlanResourcesRequest)this.beforeClientExecution(request);
        return this.executeDescribeScalingPlanResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScalingPlanResourcesResult executeDescribeScalingPlanResources(DescribeScalingPlanResourcesRequest describeScalingPlanResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingPlanResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScalingPlanResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScalingPlanResourcesRequestProtocolMarshaller(protocolFactory).marshall((DescribeScalingPlanResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScalingPlanResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeScalingPlanResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeScalingPlanResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeScalingPlanResourcesResult describeScalingPlanResourcesResult = (DescribeScalingPlanResourcesResult)response.getAwsResponse();
            return describeScalingPlanResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScalingPlansResult describeScalingPlans(DescribeScalingPlansRequest request) {
        request = (DescribeScalingPlansRequest)this.beforeClientExecution(request);
        return this.executeDescribeScalingPlans(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScalingPlansResult executeDescribeScalingPlans(DescribeScalingPlansRequest describeScalingPlansRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingPlansRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScalingPlansRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScalingPlansRequestProtocolMarshaller(protocolFactory).marshall((DescribeScalingPlansRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeScalingPlansRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeScalingPlans");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeScalingPlansResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeScalingPlansResult describeScalingPlansResult = (DescribeScalingPlansResult)response.getAwsResponse();
            return describeScalingPlansResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetScalingPlanResourceForecastDataResult getScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest request) {
        request = (GetScalingPlanResourceForecastDataRequest)this.beforeClientExecution(request);
        return this.executeGetScalingPlanResourceForecastData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetScalingPlanResourceForecastDataResult executeGetScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest getScalingPlanResourceForecastDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getScalingPlanResourceForecastDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetScalingPlanResourceForecastDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetScalingPlanResourceForecastDataRequestProtocolMarshaller(protocolFactory).marshall((GetScalingPlanResourceForecastDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getScalingPlanResourceForecastDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetScalingPlanResourceForecastData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetScalingPlanResourceForecastDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetScalingPlanResourceForecastDataResult getScalingPlanResourceForecastDataResult = (GetScalingPlanResourceForecastDataResult)response.getAwsResponse();
            return getScalingPlanResourceForecastDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateScalingPlanResult updateScalingPlan(UpdateScalingPlanRequest request) {
        request = (UpdateScalingPlanRequest)this.beforeClientExecution(request);
        return this.executeUpdateScalingPlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateScalingPlanResult executeUpdateScalingPlan(UpdateScalingPlanRequest updateScalingPlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScalingPlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateScalingPlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateScalingPlanRequestProtocolMarshaller(protocolFactory).marshall((UpdateScalingPlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateScalingPlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Auto Scaling Plans");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateScalingPlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateScalingPlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateScalingPlanResult updateScalingPlanResult = (UpdateScalingPlanResult)response.getAwsResponse();
            return updateScalingPlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

