/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.autoscalingplans.model.ApplicationSource;
import com.amazonaws.services.autoscalingplans.model.ScalingInstruction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateScalingPlanRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ApplicationSource applicationSource;
    private String scalingPlanName;
    private List<ScalingInstruction> scalingInstructions;
    private Long scalingPlanVersion;

    public void setApplicationSource(ApplicationSource applicationSource) {
        this.applicationSource = applicationSource;
    }

    public ApplicationSource getApplicationSource() {
        return this.applicationSource;
    }

    public UpdateScalingPlanRequest withApplicationSource(ApplicationSource applicationSource) {
        this.setApplicationSource(applicationSource);
        return this;
    }

    public void setScalingPlanName(String scalingPlanName) {
        this.scalingPlanName = scalingPlanName;
    }

    public String getScalingPlanName() {
        return this.scalingPlanName;
    }

    public UpdateScalingPlanRequest withScalingPlanName(String scalingPlanName) {
        this.setScalingPlanName(scalingPlanName);
        return this;
    }

    public List<ScalingInstruction> getScalingInstructions() {
        return this.scalingInstructions;
    }

    public void setScalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
        if (scalingInstructions == null) {
            this.scalingInstructions = null;
            return;
        }
        this.scalingInstructions = new ArrayList<ScalingInstruction>(scalingInstructions);
    }

    public UpdateScalingPlanRequest withScalingInstructions(ScalingInstruction ... scalingInstructions) {
        if (this.scalingInstructions == null) {
            this.setScalingInstructions(new ArrayList<ScalingInstruction>(scalingInstructions.length));
        }
        for (ScalingInstruction ele : scalingInstructions) {
            this.scalingInstructions.add(ele);
        }
        return this;
    }

    public UpdateScalingPlanRequest withScalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
        this.setScalingInstructions(scalingInstructions);
        return this;
    }

    public void setScalingPlanVersion(Long scalingPlanVersion) {
        this.scalingPlanVersion = scalingPlanVersion;
    }

    public Long getScalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public UpdateScalingPlanRequest withScalingPlanVersion(Long scalingPlanVersion) {
        this.setScalingPlanVersion(scalingPlanVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationSource() != null) {
            sb.append("ApplicationSource: ").append(this.getApplicationSource()).append(",");
        }
        if (this.getScalingPlanName() != null) {
            sb.append("ScalingPlanName: ").append(this.getScalingPlanName()).append(",");
        }
        if (this.getScalingInstructions() != null) {
            sb.append("ScalingInstructions: ").append(this.getScalingInstructions()).append(",");
        }
        if (this.getScalingPlanVersion() != null) {
            sb.append("ScalingPlanVersion: ").append(this.getScalingPlanVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingPlanRequest)) {
            return false;
        }
        UpdateScalingPlanRequest other = (UpdateScalingPlanRequest)obj;
        if (other.getApplicationSource() == null ^ this.getApplicationSource() == null) {
            return false;
        }
        if (other.getApplicationSource() != null && !other.getApplicationSource().equals(this.getApplicationSource())) {
            return false;
        }
        if (other.getScalingPlanName() == null ^ this.getScalingPlanName() == null) {
            return false;
        }
        if (other.getScalingPlanName() != null && !other.getScalingPlanName().equals(this.getScalingPlanName())) {
            return false;
        }
        if (other.getScalingInstructions() == null ^ this.getScalingInstructions() == null) {
            return false;
        }
        if (other.getScalingInstructions() != null && !other.getScalingInstructions().equals(this.getScalingInstructions())) {
            return false;
        }
        if (other.getScalingPlanVersion() == null ^ this.getScalingPlanVersion() == null) {
            return false;
        }
        return other.getScalingPlanVersion() == null || other.getScalingPlanVersion().equals(this.getScalingPlanVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationSource() == null ? 0 : this.getApplicationSource().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPlanName() == null ? 0 : this.getScalingPlanName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingInstructions() == null ? 0 : this.getScalingInstructions().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPlanVersion() == null ? 0 : this.getScalingPlanVersion().hashCode());
        return hashCode;
    }

    public UpdateScalingPlanRequest clone() {
        return (UpdateScalingPlanRequest)super.clone();
    }
}

