/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SuspendProcessesRequestMarshaller
implements Marshaller<Request<SuspendProcessesRequest>, SuspendProcessesRequest> {
    public Request<SuspendProcessesRequest> marshall(SuspendProcessesRequest suspendProcessesRequest) {
        SdkInternalList scalingProcessesList;
        if (suspendProcessesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)suspendProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SuspendProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (suspendProcessesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)suspendProcessesRequest.getAutoScalingGroupName()));
        }
        if (!(scalingProcessesList = (SdkInternalList)suspendProcessesRequest.getScalingProcesses()).isEmpty() || !scalingProcessesList.isAutoConstruct()) {
            int scalingProcessesListIndex = 1;
            for (String scalingProcessesListValue : scalingProcessesList) {
                if (scalingProcessesListValue != null) {
                    request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString((String)scalingProcessesListValue));
                }
                ++scalingProcessesListIndex;
            }
        }
        return request;
    }
}

