/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.athena.model.PreparedStatement;
import com.amazonaws.services.athena.model.UnprocessedPreparedStatementName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetPreparedStatementResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PreparedStatement> preparedStatements;
    private List<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames;

    public List<PreparedStatement> getPreparedStatements() {
        return this.preparedStatements;
    }

    public void setPreparedStatements(Collection<PreparedStatement> preparedStatements) {
        if (preparedStatements == null) {
            this.preparedStatements = null;
            return;
        }
        this.preparedStatements = new ArrayList<PreparedStatement>(preparedStatements);
    }

    public BatchGetPreparedStatementResult withPreparedStatements(PreparedStatement ... preparedStatements) {
        if (this.preparedStatements == null) {
            this.setPreparedStatements(new ArrayList<PreparedStatement>(preparedStatements.length));
        }
        for (PreparedStatement ele : preparedStatements) {
            this.preparedStatements.add(ele);
        }
        return this;
    }

    public BatchGetPreparedStatementResult withPreparedStatements(Collection<PreparedStatement> preparedStatements) {
        this.setPreparedStatements(preparedStatements);
        return this;
    }

    public List<UnprocessedPreparedStatementName> getUnprocessedPreparedStatementNames() {
        return this.unprocessedPreparedStatementNames;
    }

    public void setUnprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames) {
        if (unprocessedPreparedStatementNames == null) {
            this.unprocessedPreparedStatementNames = null;
            return;
        }
        this.unprocessedPreparedStatementNames = new ArrayList<UnprocessedPreparedStatementName>(unprocessedPreparedStatementNames);
    }

    public BatchGetPreparedStatementResult withUnprocessedPreparedStatementNames(UnprocessedPreparedStatementName ... unprocessedPreparedStatementNames) {
        if (this.unprocessedPreparedStatementNames == null) {
            this.setUnprocessedPreparedStatementNames(new ArrayList<UnprocessedPreparedStatementName>(unprocessedPreparedStatementNames.length));
        }
        for (UnprocessedPreparedStatementName ele : unprocessedPreparedStatementNames) {
            this.unprocessedPreparedStatementNames.add(ele);
        }
        return this;
    }

    public BatchGetPreparedStatementResult withUnprocessedPreparedStatementNames(Collection<UnprocessedPreparedStatementName> unprocessedPreparedStatementNames) {
        this.setUnprocessedPreparedStatementNames(unprocessedPreparedStatementNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPreparedStatements() != null) {
            sb.append("PreparedStatements: ").append(this.getPreparedStatements()).append(",");
        }
        if (this.getUnprocessedPreparedStatementNames() != null) {
            sb.append("UnprocessedPreparedStatementNames: ").append(this.getUnprocessedPreparedStatementNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPreparedStatementResult)) {
            return false;
        }
        BatchGetPreparedStatementResult other = (BatchGetPreparedStatementResult)obj;
        if (other.getPreparedStatements() == null ^ this.getPreparedStatements() == null) {
            return false;
        }
        if (other.getPreparedStatements() != null && !other.getPreparedStatements().equals(this.getPreparedStatements())) {
            return false;
        }
        if (other.getUnprocessedPreparedStatementNames() == null ^ this.getUnprocessedPreparedStatementNames() == null) {
            return false;
        }
        return other.getUnprocessedPreparedStatementNames() == null || other.getUnprocessedPreparedStatementNames().equals(this.getUnprocessedPreparedStatementNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPreparedStatements() == null ? 0 : this.getPreparedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedPreparedStatementNames() == null ? 0 : this.getUnprocessedPreparedStatementNames().hashCode());
        return hashCode;
    }

    public BatchGetPreparedStatementResult clone() {
        try {
            return (BatchGetPreparedStatementResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

