/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.arczonalshift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.arczonalshift.model.AutoshiftInResource;
import com.amazonaws.services.arczonalshift.model.ZonalAutoshiftStatus;
import com.amazonaws.services.arczonalshift.model.ZonalShiftInResource;
import com.amazonaws.services.arczonalshift.model.transform.ManagedResourceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagedResourceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Float> appliedWeights;
    private String arn;
    private List<AutoshiftInResource> autoshifts;
    private List<String> availabilityZones;
    private String name;
    private String practiceRunStatus;
    private String zonalAutoshiftStatus;
    private List<ZonalShiftInResource> zonalShifts;

    public Map<String, Float> getAppliedWeights() {
        return this.appliedWeights;
    }

    public void setAppliedWeights(Map<String, Float> appliedWeights) {
        this.appliedWeights = appliedWeights;
    }

    public ManagedResourceSummary withAppliedWeights(Map<String, Float> appliedWeights) {
        this.setAppliedWeights(appliedWeights);
        return this;
    }

    public ManagedResourceSummary addAppliedWeightsEntry(String key, Float value) {
        if (null == this.appliedWeights) {
            this.appliedWeights = new HashMap<String, Float>();
        }
        if (this.appliedWeights.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.appliedWeights.put(key, value);
        return this;
    }

    public ManagedResourceSummary clearAppliedWeightsEntries() {
        this.appliedWeights = null;
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ManagedResourceSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<AutoshiftInResource> getAutoshifts() {
        return this.autoshifts;
    }

    public void setAutoshifts(Collection<AutoshiftInResource> autoshifts) {
        if (autoshifts == null) {
            this.autoshifts = null;
            return;
        }
        this.autoshifts = new ArrayList<AutoshiftInResource>(autoshifts);
    }

    public ManagedResourceSummary withAutoshifts(AutoshiftInResource ... autoshifts) {
        if (this.autoshifts == null) {
            this.setAutoshifts(new ArrayList<AutoshiftInResource>(autoshifts.length));
        }
        for (AutoshiftInResource ele : autoshifts) {
            this.autoshifts.add(ele);
        }
        return this;
    }

    public ManagedResourceSummary withAutoshifts(Collection<AutoshiftInResource> autoshifts) {
        this.setAutoshifts(autoshifts);
        return this;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<String>(availabilityZones);
    }

    public ManagedResourceSummary withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public ManagedResourceSummary withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ManagedResourceSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPracticeRunStatus(String practiceRunStatus) {
        this.practiceRunStatus = practiceRunStatus;
    }

    public String getPracticeRunStatus() {
        return this.practiceRunStatus;
    }

    public ManagedResourceSummary withPracticeRunStatus(String practiceRunStatus) {
        this.setPracticeRunStatus(practiceRunStatus);
        return this;
    }

    public ManagedResourceSummary withPracticeRunStatus(ZonalAutoshiftStatus practiceRunStatus) {
        this.practiceRunStatus = practiceRunStatus.toString();
        return this;
    }

    public void setZonalAutoshiftStatus(String zonalAutoshiftStatus) {
        this.zonalAutoshiftStatus = zonalAutoshiftStatus;
    }

    public String getZonalAutoshiftStatus() {
        return this.zonalAutoshiftStatus;
    }

    public ManagedResourceSummary withZonalAutoshiftStatus(String zonalAutoshiftStatus) {
        this.setZonalAutoshiftStatus(zonalAutoshiftStatus);
        return this;
    }

    public ManagedResourceSummary withZonalAutoshiftStatus(ZonalAutoshiftStatus zonalAutoshiftStatus) {
        this.zonalAutoshiftStatus = zonalAutoshiftStatus.toString();
        return this;
    }

    public List<ZonalShiftInResource> getZonalShifts() {
        return this.zonalShifts;
    }

    public void setZonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
        if (zonalShifts == null) {
            this.zonalShifts = null;
            return;
        }
        this.zonalShifts = new ArrayList<ZonalShiftInResource>(zonalShifts);
    }

    public ManagedResourceSummary withZonalShifts(ZonalShiftInResource ... zonalShifts) {
        if (this.zonalShifts == null) {
            this.setZonalShifts(new ArrayList<ZonalShiftInResource>(zonalShifts.length));
        }
        for (ZonalShiftInResource ele : zonalShifts) {
            this.zonalShifts.add(ele);
        }
        return this;
    }

    public ManagedResourceSummary withZonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
        this.setZonalShifts(zonalShifts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppliedWeights() != null) {
            sb.append("AppliedWeights: ").append(this.getAppliedWeights()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAutoshifts() != null) {
            sb.append("Autoshifts: ").append(this.getAutoshifts()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPracticeRunStatus() != null) {
            sb.append("PracticeRunStatus: ").append(this.getPracticeRunStatus()).append(",");
        }
        if (this.getZonalAutoshiftStatus() != null) {
            sb.append("ZonalAutoshiftStatus: ").append(this.getZonalAutoshiftStatus()).append(",");
        }
        if (this.getZonalShifts() != null) {
            sb.append("ZonalShifts: ").append(this.getZonalShifts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedResourceSummary)) {
            return false;
        }
        ManagedResourceSummary other = (ManagedResourceSummary)obj;
        if (other.getAppliedWeights() == null ^ this.getAppliedWeights() == null) {
            return false;
        }
        if (other.getAppliedWeights() != null && !other.getAppliedWeights().equals(this.getAppliedWeights())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAutoshifts() == null ^ this.getAutoshifts() == null) {
            return false;
        }
        if (other.getAutoshifts() != null && !other.getAutoshifts().equals(this.getAutoshifts())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPracticeRunStatus() == null ^ this.getPracticeRunStatus() == null) {
            return false;
        }
        if (other.getPracticeRunStatus() != null && !other.getPracticeRunStatus().equals(this.getPracticeRunStatus())) {
            return false;
        }
        if (other.getZonalAutoshiftStatus() == null ^ this.getZonalAutoshiftStatus() == null) {
            return false;
        }
        if (other.getZonalAutoshiftStatus() != null && !other.getZonalAutoshiftStatus().equals(this.getZonalAutoshiftStatus())) {
            return false;
        }
        if (other.getZonalShifts() == null ^ this.getZonalShifts() == null) {
            return false;
        }
        return other.getZonalShifts() == null || other.getZonalShifts().equals(this.getZonalShifts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppliedWeights() == null ? 0 : this.getAppliedWeights().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAutoshifts() == null ? 0 : this.getAutoshifts().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPracticeRunStatus() == null ? 0 : this.getPracticeRunStatus().hashCode());
        hashCode = 31 * hashCode + (this.getZonalAutoshiftStatus() == null ? 0 : this.getZonalAutoshiftStatus().hashCode());
        hashCode = 31 * hashCode + (this.getZonalShifts() == null ? 0 : this.getZonalShifts().hashCode());
        return hashCode;
    }

    public ManagedResourceSummary clone() {
        try {
            return (ManagedResourceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ManagedResourceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

