/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appsync.model.AdditionalAuthenticationProvider;
import com.amazonaws.services.appsync.model.AuthenticationType;
import com.amazonaws.services.appsync.model.LambdaAuthorizerConfig;
import com.amazonaws.services.appsync.model.LogConfig;
import com.amazonaws.services.appsync.model.OpenIDConnectConfig;
import com.amazonaws.services.appsync.model.UserPoolConfig;
import com.amazonaws.services.appsync.model.transform.GraphqlApiMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphqlApi
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String apiId;
    private String authenticationType;
    private LogConfig logConfig;
    private UserPoolConfig userPoolConfig;
    private OpenIDConnectConfig openIDConnectConfig;
    private String arn;
    private Map<String, String> uris;
    private Map<String, String> tags;
    private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;
    private Boolean xrayEnabled;
    private String wafWebAclArn;
    private LambdaAuthorizerConfig lambdaAuthorizerConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GraphqlApi withName(String name) {
        this.setName(name);
        return this;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getApiId() {
        return this.apiId;
    }

    public GraphqlApi withApiId(String apiId) {
        this.setApiId(apiId);
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public GraphqlApi withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public GraphqlApi withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public GraphqlApi withLogConfig(LogConfig logConfig) {
        this.setLogConfig(logConfig);
        return this;
    }

    public void setUserPoolConfig(UserPoolConfig userPoolConfig) {
        this.userPoolConfig = userPoolConfig;
    }

    public UserPoolConfig getUserPoolConfig() {
        return this.userPoolConfig;
    }

    public GraphqlApi withUserPoolConfig(UserPoolConfig userPoolConfig) {
        this.setUserPoolConfig(userPoolConfig);
        return this;
    }

    public void setOpenIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
        this.openIDConnectConfig = openIDConnectConfig;
    }

    public OpenIDConnectConfig getOpenIDConnectConfig() {
        return this.openIDConnectConfig;
    }

    public GraphqlApi withOpenIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
        this.setOpenIDConnectConfig(openIDConnectConfig);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public GraphqlApi withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public Map<String, String> getUris() {
        return this.uris;
    }

    public void setUris(Map<String, String> uris) {
        this.uris = uris;
    }

    public GraphqlApi withUris(Map<String, String> uris) {
        this.setUris(uris);
        return this;
    }

    public GraphqlApi addUrisEntry(String key, String value) {
        if (null == this.uris) {
            this.uris = new HashMap<String, String>();
        }
        if (this.uris.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.uris.put(key, value);
        return this;
    }

    public GraphqlApi clearUrisEntries() {
        this.uris = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GraphqlApi withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GraphqlApi addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GraphqlApi clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<AdditionalAuthenticationProvider> getAdditionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders;
    }

    public void setAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
        if (additionalAuthenticationProviders == null) {
            this.additionalAuthenticationProviders = null;
            return;
        }
        this.additionalAuthenticationProviders = new ArrayList<AdditionalAuthenticationProvider>(additionalAuthenticationProviders);
    }

    public GraphqlApi withAdditionalAuthenticationProviders(AdditionalAuthenticationProvider ... additionalAuthenticationProviders) {
        if (this.additionalAuthenticationProviders == null) {
            this.setAdditionalAuthenticationProviders(new ArrayList<AdditionalAuthenticationProvider>(additionalAuthenticationProviders.length));
        }
        for (AdditionalAuthenticationProvider ele : additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders.add(ele);
        }
        return this;
    }

    public GraphqlApi withAdditionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
        this.setAdditionalAuthenticationProviders(additionalAuthenticationProviders);
        return this;
    }

    public void setXrayEnabled(Boolean xrayEnabled) {
        this.xrayEnabled = xrayEnabled;
    }

    public Boolean getXrayEnabled() {
        return this.xrayEnabled;
    }

    public GraphqlApi withXrayEnabled(Boolean xrayEnabled) {
        this.setXrayEnabled(xrayEnabled);
        return this;
    }

    public Boolean isXrayEnabled() {
        return this.xrayEnabled;
    }

    public void setWafWebAclArn(String wafWebAclArn) {
        this.wafWebAclArn = wafWebAclArn;
    }

    public String getWafWebAclArn() {
        return this.wafWebAclArn;
    }

    public GraphqlApi withWafWebAclArn(String wafWebAclArn) {
        this.setWafWebAclArn(wafWebAclArn);
        return this;
    }

    public void setLambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
        this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
    }

    public LambdaAuthorizerConfig getLambdaAuthorizerConfig() {
        return this.lambdaAuthorizerConfig;
    }

    public GraphqlApi withLambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
        this.setLambdaAuthorizerConfig(lambdaAuthorizerConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getApiId() != null) {
            sb.append("ApiId: ").append(this.getApiId()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getLogConfig() != null) {
            sb.append("LogConfig: ").append(this.getLogConfig()).append(",");
        }
        if (this.getUserPoolConfig() != null) {
            sb.append("UserPoolConfig: ").append(this.getUserPoolConfig()).append(",");
        }
        if (this.getOpenIDConnectConfig() != null) {
            sb.append("OpenIDConnectConfig: ").append(this.getOpenIDConnectConfig()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getUris() != null) {
            sb.append("Uris: ").append(this.getUris()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAdditionalAuthenticationProviders() != null) {
            sb.append("AdditionalAuthenticationProviders: ").append(this.getAdditionalAuthenticationProviders()).append(",");
        }
        if (this.getXrayEnabled() != null) {
            sb.append("XrayEnabled: ").append(this.getXrayEnabled()).append(",");
        }
        if (this.getWafWebAclArn() != null) {
            sb.append("WafWebAclArn: ").append(this.getWafWebAclArn()).append(",");
        }
        if (this.getLambdaAuthorizerConfig() != null) {
            sb.append("LambdaAuthorizerConfig: ").append(this.getLambdaAuthorizerConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphqlApi)) {
            return false;
        }
        GraphqlApi other = (GraphqlApi)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getApiId() == null ^ this.getApiId() == null) {
            return false;
        }
        if (other.getApiId() != null && !other.getApiId().equals(this.getApiId())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getLogConfig() == null ^ this.getLogConfig() == null) {
            return false;
        }
        if (other.getLogConfig() != null && !other.getLogConfig().equals(this.getLogConfig())) {
            return false;
        }
        if (other.getUserPoolConfig() == null ^ this.getUserPoolConfig() == null) {
            return false;
        }
        if (other.getUserPoolConfig() != null && !other.getUserPoolConfig().equals(this.getUserPoolConfig())) {
            return false;
        }
        if (other.getOpenIDConnectConfig() == null ^ this.getOpenIDConnectConfig() == null) {
            return false;
        }
        if (other.getOpenIDConnectConfig() != null && !other.getOpenIDConnectConfig().equals(this.getOpenIDConnectConfig())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getUris() == null ^ this.getUris() == null) {
            return false;
        }
        if (other.getUris() != null && !other.getUris().equals(this.getUris())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAdditionalAuthenticationProviders() == null ^ this.getAdditionalAuthenticationProviders() == null) {
            return false;
        }
        if (other.getAdditionalAuthenticationProviders() != null && !other.getAdditionalAuthenticationProviders().equals(this.getAdditionalAuthenticationProviders())) {
            return false;
        }
        if (other.getXrayEnabled() == null ^ this.getXrayEnabled() == null) {
            return false;
        }
        if (other.getXrayEnabled() != null && !other.getXrayEnabled().equals(this.getXrayEnabled())) {
            return false;
        }
        if (other.getWafWebAclArn() == null ^ this.getWafWebAclArn() == null) {
            return false;
        }
        if (other.getWafWebAclArn() != null && !other.getWafWebAclArn().equals(this.getWafWebAclArn())) {
            return false;
        }
        if (other.getLambdaAuthorizerConfig() == null ^ this.getLambdaAuthorizerConfig() == null) {
            return false;
        }
        return other.getLambdaAuthorizerConfig() == null || other.getLambdaAuthorizerConfig().equals(this.getLambdaAuthorizerConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getApiId() == null ? 0 : this.getApiId().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfig() == null ? 0 : this.getLogConfig().hashCode());
        hashCode = 31 * hashCode + (this.getUserPoolConfig() == null ? 0 : this.getUserPoolConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIDConnectConfig() == null ? 0 : this.getOpenIDConnectConfig().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getUris() == null ? 0 : this.getUris().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalAuthenticationProviders() == null ? 0 : this.getAdditionalAuthenticationProviders().hashCode());
        hashCode = 31 * hashCode + (this.getXrayEnabled() == null ? 0 : this.getXrayEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getWafWebAclArn() == null ? 0 : this.getWafWebAclArn().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaAuthorizerConfig() == null ? 0 : this.getLambdaAuthorizerConfig().hashCode());
        return hashCode;
    }

    public GraphqlApi clone() {
        try {
            return (GraphqlApi)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GraphqlApiMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

