/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appstream.model.AccessEndpoint;
import com.amazonaws.services.appstream.model.ApplicationSettings;
import com.amazonaws.services.appstream.model.StackAttribute;
import com.amazonaws.services.appstream.model.StorageConnector;
import com.amazonaws.services.appstream.model.UserSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String displayName;
    private String description;
    private String name;
    private List<StorageConnector> storageConnectors;
    @Deprecated
    private Boolean deleteStorageConnectors;
    private String redirectURL;
    private String feedbackURL;
    private List<String> attributesToDelete;
    private List<UserSetting> userSettings;
    private ApplicationSettings applicationSettings;
    private List<AccessEndpoint> accessEndpoints;
    private List<String> embedHostDomains;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UpdateStackRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateStackRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateStackRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public UpdateStackRequest withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    @Deprecated
    public void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
        this.deleteStorageConnectors = deleteStorageConnectors;
    }

    @Deprecated
    public Boolean getDeleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    @Deprecated
    public UpdateStackRequest withDeleteStorageConnectors(Boolean deleteStorageConnectors) {
        this.setDeleteStorageConnectors(deleteStorageConnectors);
        return this;
    }

    @Deprecated
    public Boolean isDeleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public UpdateStackRequest withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public UpdateStackRequest withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public List<String> getAttributesToDelete() {
        return this.attributesToDelete;
    }

    public void setAttributesToDelete(Collection<String> attributesToDelete) {
        if (attributesToDelete == null) {
            this.attributesToDelete = null;
            return;
        }
        this.attributesToDelete = new ArrayList<String>(attributesToDelete);
    }

    public UpdateStackRequest withAttributesToDelete(String ... attributesToDelete) {
        if (this.attributesToDelete == null) {
            this.setAttributesToDelete(new ArrayList<String>(attributesToDelete.length));
        }
        for (String ele : attributesToDelete) {
            this.attributesToDelete.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withAttributesToDelete(Collection<String> attributesToDelete) {
        this.setAttributesToDelete(attributesToDelete);
        return this;
    }

    public UpdateStackRequest withAttributesToDelete(StackAttribute ... attributesToDelete) {
        ArrayList<String> attributesToDeleteCopy = new ArrayList<String>(attributesToDelete.length);
        for (StackAttribute value : attributesToDelete) {
            attributesToDeleteCopy.add(value.toString());
        }
        if (this.getAttributesToDelete() == null) {
            this.setAttributesToDelete(attributesToDeleteCopy);
        } else {
            this.getAttributesToDelete().addAll(attributesToDeleteCopy);
        }
        return this;
    }

    public List<UserSetting> getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(Collection<UserSetting> userSettings) {
        if (userSettings == null) {
            this.userSettings = null;
            return;
        }
        this.userSettings = new ArrayList<UserSetting>(userSettings);
    }

    public UpdateStackRequest withUserSettings(UserSetting ... userSettings) {
        if (this.userSettings == null) {
            this.setUserSettings(new ArrayList<UserSetting>(userSettings.length));
        }
        for (UserSetting ele : userSettings) {
            this.userSettings.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withUserSettings(Collection<UserSetting> userSettings) {
        this.setUserSettings(userSettings);
        return this;
    }

    public void setApplicationSettings(ApplicationSettings applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public ApplicationSettings getApplicationSettings() {
        return this.applicationSettings;
    }

    public UpdateStackRequest withApplicationSettings(ApplicationSettings applicationSettings) {
        this.setApplicationSettings(applicationSettings);
        return this;
    }

    public List<AccessEndpoint> getAccessEndpoints() {
        return this.accessEndpoints;
    }

    public void setAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        if (accessEndpoints == null) {
            this.accessEndpoints = null;
            return;
        }
        this.accessEndpoints = new ArrayList<AccessEndpoint>(accessEndpoints);
    }

    public UpdateStackRequest withAccessEndpoints(AccessEndpoint ... accessEndpoints) {
        if (this.accessEndpoints == null) {
            this.setAccessEndpoints(new ArrayList<AccessEndpoint>(accessEndpoints.length));
        }
        for (AccessEndpoint ele : accessEndpoints) {
            this.accessEndpoints.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        this.setAccessEndpoints(accessEndpoints);
        return this;
    }

    public List<String> getEmbedHostDomains() {
        return this.embedHostDomains;
    }

    public void setEmbedHostDomains(Collection<String> embedHostDomains) {
        if (embedHostDomains == null) {
            this.embedHostDomains = null;
            return;
        }
        this.embedHostDomains = new ArrayList<String>(embedHostDomains);
    }

    public UpdateStackRequest withEmbedHostDomains(String ... embedHostDomains) {
        if (this.embedHostDomains == null) {
            this.setEmbedHostDomains(new ArrayList<String>(embedHostDomains.length));
        }
        for (String ele : embedHostDomains) {
            this.embedHostDomains.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withEmbedHostDomains(Collection<String> embedHostDomains) {
        this.setEmbedHostDomains(embedHostDomains);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getDeleteStorageConnectors() != null) {
            sb.append("DeleteStorageConnectors: ").append(this.getDeleteStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL()).append(",");
        }
        if (this.getAttributesToDelete() != null) {
            sb.append("AttributesToDelete: ").append(this.getAttributesToDelete()).append(",");
        }
        if (this.getUserSettings() != null) {
            sb.append("UserSettings: ").append(this.getUserSettings()).append(",");
        }
        if (this.getApplicationSettings() != null) {
            sb.append("ApplicationSettings: ").append(this.getApplicationSettings()).append(",");
        }
        if (this.getAccessEndpoints() != null) {
            sb.append("AccessEndpoints: ").append(this.getAccessEndpoints()).append(",");
        }
        if (this.getEmbedHostDomains() != null) {
            sb.append("EmbedHostDomains: ").append(this.getEmbedHostDomains());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)obj;
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getDeleteStorageConnectors() == null ^ this.getDeleteStorageConnectors() == null) {
            return false;
        }
        if (other.getDeleteStorageConnectors() != null && !other.getDeleteStorageConnectors().equals(this.getDeleteStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        if (other.getFeedbackURL() != null && !other.getFeedbackURL().equals(this.getFeedbackURL())) {
            return false;
        }
        if (other.getAttributesToDelete() == null ^ this.getAttributesToDelete() == null) {
            return false;
        }
        if (other.getAttributesToDelete() != null && !other.getAttributesToDelete().equals(this.getAttributesToDelete())) {
            return false;
        }
        if (other.getUserSettings() == null ^ this.getUserSettings() == null) {
            return false;
        }
        if (other.getUserSettings() != null && !other.getUserSettings().equals(this.getUserSettings())) {
            return false;
        }
        if (other.getApplicationSettings() == null ^ this.getApplicationSettings() == null) {
            return false;
        }
        if (other.getApplicationSettings() != null && !other.getApplicationSettings().equals(this.getApplicationSettings())) {
            return false;
        }
        if (other.getAccessEndpoints() == null ^ this.getAccessEndpoints() == null) {
            return false;
        }
        if (other.getAccessEndpoints() != null && !other.getAccessEndpoints().equals(this.getAccessEndpoints())) {
            return false;
        }
        if (other.getEmbedHostDomains() == null ^ this.getEmbedHostDomains() == null) {
            return false;
        }
        return other.getEmbedHostDomains() == null || other.getEmbedHostDomains().equals(this.getEmbedHostDomains());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteStorageConnectors() == null ? 0 : this.getDeleteStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToDelete() == null ? 0 : this.getAttributesToDelete().hashCode());
        hashCode = 31 * hashCode + (this.getUserSettings() == null ? 0 : this.getUserSettings().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSettings() == null ? 0 : this.getApplicationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getAccessEndpoints() == null ? 0 : this.getAccessEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getEmbedHostDomains() == null ? 0 : this.getEmbedHostDomains().hashCode());
        return hashCode;
    }

    public UpdateStackRequest clone() {
        return (UpdateStackRequest)super.clone();
    }
}

