/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.StackError;
import com.amazonaws.services.appstream.model.StorageConnector;
import com.amazonaws.services.appstream.model.transform.StackMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Stack
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String description;
    private String displayName;
    private Date createdTime;
    private List<StorageConnector> storageConnectors;
    private String redirectURL;
    private String feedbackURL;
    private List<StackError> stackErrors;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Stack withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Stack withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Stack withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Stack withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Stack withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public Stack withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public Stack withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public Stack withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public Stack withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public List<StackError> getStackErrors() {
        return this.stackErrors;
    }

    public void setStackErrors(Collection<StackError> stackErrors) {
        if (stackErrors == null) {
            this.stackErrors = null;
            return;
        }
        this.stackErrors = new ArrayList<StackError>(stackErrors);
    }

    public Stack withStackErrors(StackError ... stackErrors) {
        if (this.stackErrors == null) {
            this.setStackErrors(new ArrayList<StackError>(stackErrors.length));
        }
        for (StackError ele : stackErrors) {
            this.stackErrors.add(ele);
        }
        return this;
    }

    public Stack withStackErrors(Collection<StackError> stackErrors) {
        this.setStackErrors(stackErrors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL()).append(",");
        }
        if (this.getStackErrors() != null) {
            sb.append("StackErrors: ").append(this.getStackErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        if (other.getFeedbackURL() != null && !other.getFeedbackURL().equals(this.getFeedbackURL())) {
            return false;
        }
        if (other.getStackErrors() == null ^ this.getStackErrors() == null) {
            return false;
        }
        return other.getStackErrors() == null || other.getStackErrors().equals(this.getStackErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        hashCode = 31 * hashCode + (this.getStackErrors() == null ? 0 : this.getStackErrors().hashCode());
        return hashCode;
    }

    public Stack clone() {
        try {
            return (Stack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

