/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appregistry.AWSAppRegistry;
import com.amazonaws.services.appregistry.AWSAppRegistryClientBuilder;
import com.amazonaws.services.appregistry.model.AWSAppRegistryException;
import com.amazonaws.services.appregistry.model.AssociateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.AssociateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.AssociateResourceRequest;
import com.amazonaws.services.appregistry.model.AssociateResourceResult;
import com.amazonaws.services.appregistry.model.CreateApplicationRequest;
import com.amazonaws.services.appregistry.model.CreateApplicationResult;
import com.amazonaws.services.appregistry.model.CreateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.CreateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DeleteApplicationRequest;
import com.amazonaws.services.appregistry.model.DeleteApplicationResult;
import com.amazonaws.services.appregistry.model.DeleteAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.DeleteAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DisassociateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.DisassociateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DisassociateResourceRequest;
import com.amazonaws.services.appregistry.model.DisassociateResourceResult;
import com.amazonaws.services.appregistry.model.GetApplicationRequest;
import com.amazonaws.services.appregistry.model.GetApplicationResult;
import com.amazonaws.services.appregistry.model.GetAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.GetAttributeGroupResult;
import com.amazonaws.services.appregistry.model.ListApplicationsRequest;
import com.amazonaws.services.appregistry.model.ListApplicationsResult;
import com.amazonaws.services.appregistry.model.ListAssociatedAttributeGroupsRequest;
import com.amazonaws.services.appregistry.model.ListAssociatedAttributeGroupsResult;
import com.amazonaws.services.appregistry.model.ListAssociatedResourcesRequest;
import com.amazonaws.services.appregistry.model.ListAssociatedResourcesResult;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsRequest;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsResult;
import com.amazonaws.services.appregistry.model.ListTagsForResourceRequest;
import com.amazonaws.services.appregistry.model.ListTagsForResourceResult;
import com.amazonaws.services.appregistry.model.TagResourceRequest;
import com.amazonaws.services.appregistry.model.TagResourceResult;
import com.amazonaws.services.appregistry.model.UntagResourceRequest;
import com.amazonaws.services.appregistry.model.UntagResourceResult;
import com.amazonaws.services.appregistry.model.UpdateApplicationRequest;
import com.amazonaws.services.appregistry.model.UpdateApplicationResult;
import com.amazonaws.services.appregistry.model.UpdateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.UpdateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.transform.AssociateAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.AssociateAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.AssociateResourceRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.AssociateResourceResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.CreateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.CreateAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.CreateAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.DeleteApplicationRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.DeleteAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.DeleteAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.DisassociateAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.DisassociateAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.DisassociateResourceRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.DisassociateResourceResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.GetApplicationRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.GetApplicationResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.GetAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.GetAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ListApplicationsRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAssociatedAttributeGroupsRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAssociatedAttributeGroupsResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAssociatedResourcesRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAssociatedResourcesResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAttributeGroupsRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.ListAttributeGroupsResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.UpdateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.UpdateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.UpdateAttributeGroupRequestProtocolMarshaller;
import com.amazonaws.services.appregistry.model.transform.UpdateAttributeGroupResultJsonUnmarshaller;
import com.amazonaws.services.appregistry.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSAppRegistryClient
extends AmazonWebServiceClient
implements AWSAppRegistry {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAppRegistry.class);
    private static final String DEFAULT_SIGNING_NAME = "servicecatalog";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSAppRegistryException.class));

    public static AWSAppRegistryClientBuilder builder() {
        return AWSAppRegistryClientBuilder.standard();
    }

    AWSAppRegistryClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSAppRegistryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("servicecatalog-appregistry");
        this.setEndpoint("servicecatalog-appregistry.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appregistry/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appregistry/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateAttributeGroupResult associateAttributeGroup(AssociateAttributeGroupRequest request) {
        request = (AssociateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeAssociateAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateAttributeGroupResult executeAssociateAttributeGroup(AssociateAttributeGroupRequest associateAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((AssociateAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateAttributeGroupResult associateAttributeGroupResult = (AssociateAttributeGroupResult)response.getAwsResponse();
            return associateAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateResourceResult associateResource(AssociateResourceRequest request) {
        request = (AssociateResourceRequest)this.beforeClientExecution(request);
        return this.executeAssociateResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateResourceResult executeAssociateResource(AssociateResourceRequest associateResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateResourceRequestProtocolMarshaller(protocolFactory).marshall((AssociateResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateResourceResult associateResourceResult = (AssociateResourceResult)response.getAwsResponse();
            return associateResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        request = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executeCreateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApplicationResult executeCreateApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestProtocolMarshaller(protocolFactory).marshall((CreateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAttributeGroupResult createAttributeGroup(CreateAttributeGroupRequest request) {
        request = (CreateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAttributeGroupResult executeCreateAttributeGroup(CreateAttributeGroupRequest createAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAttributeGroupResult createAttributeGroupResult = (CreateAttributeGroupResult)response.getAwsResponse();
            return createAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        request = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationResult executeDeleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAttributeGroupResult deleteAttributeGroup(DeleteAttributeGroupRequest request) {
        request = (DeleteAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAttributeGroupResult executeDeleteAttributeGroup(DeleteAttributeGroupRequest deleteAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAttributeGroupResult deleteAttributeGroupResult = (DeleteAttributeGroupResult)response.getAwsResponse();
            return deleteAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateAttributeGroupResult disassociateAttributeGroup(DisassociateAttributeGroupRequest request) {
        request = (DisassociateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeDisassociateAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateAttributeGroupResult executeDisassociateAttributeGroup(DisassociateAttributeGroupRequest disassociateAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((DisassociateAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateAttributeGroupResult disassociateAttributeGroupResult = (DisassociateAttributeGroupResult)response.getAwsResponse();
            return disassociateAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateResourceResult disassociateResource(DisassociateResourceRequest request) {
        request = (DisassociateResourceRequest)this.beforeClientExecution(request);
        return this.executeDisassociateResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateResourceResult executeDisassociateResource(DisassociateResourceRequest disassociateResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateResourceRequestProtocolMarshaller(protocolFactory).marshall((DisassociateResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateResourceResult disassociateResourceResult = (DisassociateResourceResult)response.getAwsResponse();
            return disassociateResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetApplicationResult getApplication(GetApplicationRequest request) {
        request = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executeGetApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetApplicationResult executeGetApplication(GetApplicationRequest getApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApplicationRequestProtocolMarshaller(protocolFactory).marshall((GetApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApplicationResult getApplicationResult = (GetApplicationResult)response.getAwsResponse();
            return getApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAttributeGroupResult getAttributeGroup(GetAttributeGroupRequest request) {
        request = (GetAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeGetAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAttributeGroupResult executeGetAttributeGroup(GetAttributeGroupRequest getAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((GetAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAttributeGroupResult getAttributeGroupResult = (GetAttributeGroupResult)response.getAwsResponse();
            return getAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        request = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executeListApplications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationsResult executeListApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssociatedAttributeGroupsResult listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest request) {
        request = (ListAssociatedAttributeGroupsRequest)this.beforeClientExecution(request);
        return this.executeListAssociatedAttributeGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssociatedAttributeGroupsResult executeListAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociatedAttributeGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociatedAttributeGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociatedAttributeGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListAssociatedAttributeGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssociatedAttributeGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssociatedAttributeGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssociatedAttributeGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociatedAttributeGroupsResult listAssociatedAttributeGroupsResult = (ListAssociatedAttributeGroupsResult)response.getAwsResponse();
            return listAssociatedAttributeGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssociatedResourcesResult listAssociatedResources(ListAssociatedResourcesRequest request) {
        request = (ListAssociatedResourcesRequest)this.beforeClientExecution(request);
        return this.executeListAssociatedResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssociatedResourcesResult executeListAssociatedResources(ListAssociatedResourcesRequest listAssociatedResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociatedResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociatedResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociatedResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListAssociatedResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssociatedResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssociatedResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssociatedResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssociatedResourcesResult listAssociatedResourcesResult = (ListAssociatedResourcesResult)response.getAwsResponse();
            return listAssociatedResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAttributeGroupsResult listAttributeGroups(ListAttributeGroupsRequest request) {
        request = (ListAttributeGroupsRequest)this.beforeClientExecution(request);
        return this.executeListAttributeGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAttributeGroupsResult executeListAttributeGroups(ListAttributeGroupsRequest listAttributeGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttributeGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttributeGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttributeGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListAttributeGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttributeGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAttributeGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttributeGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttributeGroupsResult listAttributeGroupsResult = (ListAttributeGroupsResult)response.getAwsResponse();
            return listAttributeGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        request = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executeUpdateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateApplicationResult executeUpdateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationRequestProtocolMarshaller(protocolFactory).marshall((UpdateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationResult updateApplicationResult = (UpdateApplicationResult)response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAttributeGroupResult updateAttributeGroup(UpdateAttributeGroupRequest request) {
        request = (UpdateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateAttributeGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAttributeGroupResult executeUpdateAttributeGroup(UpdateAttributeGroupRequest updateAttributeGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAttributeGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAttributeGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAttributeGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateAttributeGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAttributeGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Service Catalog AppRegistry");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAttributeGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAttributeGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAttributeGroupResult updateAttributeGroupResult = (UpdateAttributeGroupResult)response.getAwsResponse();
            return updateAttributeGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

