/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.VirtualGatewayBackendDefaults;
import com.amazonaws.services.appmesh.model.VirtualGatewayListener;
import com.amazonaws.services.appmesh.model.VirtualGatewayLogging;
import com.amazonaws.services.appmesh.model.transform.VirtualGatewaySpecMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VirtualGatewaySpec
implements Serializable,
Cloneable,
StructuredPojo {
    private VirtualGatewayBackendDefaults backendDefaults;
    private List<VirtualGatewayListener> listeners;
    private VirtualGatewayLogging logging;

    public void setBackendDefaults(VirtualGatewayBackendDefaults backendDefaults) {
        this.backendDefaults = backendDefaults;
    }

    public VirtualGatewayBackendDefaults getBackendDefaults() {
        return this.backendDefaults;
    }

    public VirtualGatewaySpec withBackendDefaults(VirtualGatewayBackendDefaults backendDefaults) {
        this.setBackendDefaults(backendDefaults);
        return this;
    }

    public List<VirtualGatewayListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<VirtualGatewayListener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        this.listeners = new ArrayList<VirtualGatewayListener>(listeners);
    }

    public VirtualGatewaySpec withListeners(VirtualGatewayListener ... listeners) {
        if (this.listeners == null) {
            this.setListeners(new ArrayList<VirtualGatewayListener>(listeners.length));
        }
        for (VirtualGatewayListener ele : listeners) {
            this.listeners.add(ele);
        }
        return this;
    }

    public VirtualGatewaySpec withListeners(Collection<VirtualGatewayListener> listeners) {
        this.setListeners(listeners);
        return this;
    }

    public void setLogging(VirtualGatewayLogging logging) {
        this.logging = logging;
    }

    public VirtualGatewayLogging getLogging() {
        return this.logging;
    }

    public VirtualGatewaySpec withLogging(VirtualGatewayLogging logging) {
        this.setLogging(logging);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackendDefaults() != null) {
            sb.append("BackendDefaults: ").append(this.getBackendDefaults()).append(",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: ").append(this.getListeners()).append(",");
        }
        if (this.getLogging() != null) {
            sb.append("Logging: ").append(this.getLogging());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewaySpec)) {
            return false;
        }
        VirtualGatewaySpec other = (VirtualGatewaySpec)obj;
        if (other.getBackendDefaults() == null ^ this.getBackendDefaults() == null) {
            return false;
        }
        if (other.getBackendDefaults() != null && !other.getBackendDefaults().equals(this.getBackendDefaults())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        if (other.getListeners() != null && !other.getListeners().equals(this.getListeners())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        return other.getLogging() == null || other.getLogging().equals(this.getLogging());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackendDefaults() == null ? 0 : this.getBackendDefaults().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : this.getListeners().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        return hashCode;
    }

    public VirtualGatewaySpec clone() {
        try {
            return (VirtualGatewaySpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VirtualGatewaySpecMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

