/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appmesh.model.TagRef;
import com.amazonaws.services.appmesh.model.VirtualNodeSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVirtualNodeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String meshName;
    private VirtualNodeSpec spec;
    private List<TagRef> tags;
    private String virtualNodeName;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateVirtualNodeRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setMeshName(String meshName) {
        this.meshName = meshName;
    }

    public String getMeshName() {
        return this.meshName;
    }

    public CreateVirtualNodeRequest withMeshName(String meshName) {
        this.setMeshName(meshName);
        return this;
    }

    public void setSpec(VirtualNodeSpec spec) {
        this.spec = spec;
    }

    public VirtualNodeSpec getSpec() {
        return this.spec;
    }

    public CreateVirtualNodeRequest withSpec(VirtualNodeSpec spec) {
        this.setSpec(spec);
        return this;
    }

    public List<TagRef> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagRef> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagRef>(tags);
    }

    public CreateVirtualNodeRequest withTags(TagRef ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagRef>(tags.length));
        }
        for (TagRef ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVirtualNodeRequest withTags(Collection<TagRef> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVirtualNodeName(String virtualNodeName) {
        this.virtualNodeName = virtualNodeName;
    }

    public String getVirtualNodeName() {
        return this.virtualNodeName;
    }

    public CreateVirtualNodeRequest withVirtualNodeName(String virtualNodeName) {
        this.setVirtualNodeName(virtualNodeName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getMeshName() != null) {
            sb.append("MeshName: ").append(this.getMeshName()).append(",");
        }
        if (this.getSpec() != null) {
            sb.append("Spec: ").append(this.getSpec()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVirtualNodeName() != null) {
            sb.append("VirtualNodeName: ").append(this.getVirtualNodeName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualNodeRequest)) {
            return false;
        }
        CreateVirtualNodeRequest other = (CreateVirtualNodeRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getMeshName() == null ^ this.getMeshName() == null) {
            return false;
        }
        if (other.getMeshName() != null && !other.getMeshName().equals(this.getMeshName())) {
            return false;
        }
        if (other.getSpec() == null ^ this.getSpec() == null) {
            return false;
        }
        if (other.getSpec() != null && !other.getSpec().equals(this.getSpec())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVirtualNodeName() == null ^ this.getVirtualNodeName() == null) {
            return false;
        }
        return other.getVirtualNodeName() == null || other.getVirtualNodeName().equals(this.getVirtualNodeName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getMeshName() == null ? 0 : this.getMeshName().hashCode());
        hashCode = 31 * hashCode + (this.getSpec() == null ? 0 : this.getSpec().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualNodeName() == null ? 0 : this.getVirtualNodeName().hashCode());
        return hashCode;
    }

    public CreateVirtualNodeRequest clone() {
        return (CreateVirtualNodeRequest)super.clone();
    }
}

