/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appmesh.AWSAppMeshAsync;
import com.amazonaws.services.appmesh.AWSAppMeshAsyncClientBuilder;
import com.amazonaws.services.appmesh.AWSAppMeshClient;
import com.amazonaws.services.appmesh.model.CreateMeshRequest;
import com.amazonaws.services.appmesh.model.CreateMeshResult;
import com.amazonaws.services.appmesh.model.CreateRouteRequest;
import com.amazonaws.services.appmesh.model.CreateRouteResult;
import com.amazonaws.services.appmesh.model.CreateVirtualNodeRequest;
import com.amazonaws.services.appmesh.model.CreateVirtualNodeResult;
import com.amazonaws.services.appmesh.model.CreateVirtualRouterRequest;
import com.amazonaws.services.appmesh.model.CreateVirtualRouterResult;
import com.amazonaws.services.appmesh.model.CreateVirtualServiceRequest;
import com.amazonaws.services.appmesh.model.CreateVirtualServiceResult;
import com.amazonaws.services.appmesh.model.DeleteMeshRequest;
import com.amazonaws.services.appmesh.model.DeleteMeshResult;
import com.amazonaws.services.appmesh.model.DeleteRouteRequest;
import com.amazonaws.services.appmesh.model.DeleteRouteResult;
import com.amazonaws.services.appmesh.model.DeleteVirtualNodeRequest;
import com.amazonaws.services.appmesh.model.DeleteVirtualNodeResult;
import com.amazonaws.services.appmesh.model.DeleteVirtualRouterRequest;
import com.amazonaws.services.appmesh.model.DeleteVirtualRouterResult;
import com.amazonaws.services.appmesh.model.DeleteVirtualServiceRequest;
import com.amazonaws.services.appmesh.model.DeleteVirtualServiceResult;
import com.amazonaws.services.appmesh.model.DescribeMeshRequest;
import com.amazonaws.services.appmesh.model.DescribeMeshResult;
import com.amazonaws.services.appmesh.model.DescribeRouteRequest;
import com.amazonaws.services.appmesh.model.DescribeRouteResult;
import com.amazonaws.services.appmesh.model.DescribeVirtualNodeRequest;
import com.amazonaws.services.appmesh.model.DescribeVirtualNodeResult;
import com.amazonaws.services.appmesh.model.DescribeVirtualRouterRequest;
import com.amazonaws.services.appmesh.model.DescribeVirtualRouterResult;
import com.amazonaws.services.appmesh.model.DescribeVirtualServiceRequest;
import com.amazonaws.services.appmesh.model.DescribeVirtualServiceResult;
import com.amazonaws.services.appmesh.model.ListMeshesRequest;
import com.amazonaws.services.appmesh.model.ListMeshesResult;
import com.amazonaws.services.appmesh.model.ListRoutesRequest;
import com.amazonaws.services.appmesh.model.ListRoutesResult;
import com.amazonaws.services.appmesh.model.ListVirtualNodesRequest;
import com.amazonaws.services.appmesh.model.ListVirtualNodesResult;
import com.amazonaws.services.appmesh.model.ListVirtualRoutersRequest;
import com.amazonaws.services.appmesh.model.ListVirtualRoutersResult;
import com.amazonaws.services.appmesh.model.ListVirtualServicesRequest;
import com.amazonaws.services.appmesh.model.ListVirtualServicesResult;
import com.amazonaws.services.appmesh.model.UpdateRouteRequest;
import com.amazonaws.services.appmesh.model.UpdateRouteResult;
import com.amazonaws.services.appmesh.model.UpdateVirtualNodeRequest;
import com.amazonaws.services.appmesh.model.UpdateVirtualNodeResult;
import com.amazonaws.services.appmesh.model.UpdateVirtualRouterRequest;
import com.amazonaws.services.appmesh.model.UpdateVirtualRouterResult;
import com.amazonaws.services.appmesh.model.UpdateVirtualServiceRequest;
import com.amazonaws.services.appmesh.model.UpdateVirtualServiceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAppMeshAsyncClient
extends AWSAppMeshClient
implements AWSAppMeshAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAppMeshAsyncClientBuilder asyncBuilder() {
        return AWSAppMeshAsyncClientBuilder.standard();
    }

    AWSAppMeshAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMeshResult> createMeshAsync(CreateMeshRequest request) {
        return this.createMeshAsync(request, null);
    }

    @Override
    public Future<CreateMeshResult> createMeshAsync(CreateMeshRequest request, final AsyncHandler<CreateMeshRequest, CreateMeshResult> asyncHandler) {
        final CreateMeshRequest finalRequest = (CreateMeshRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMeshResult>(){

            @Override
            public CreateMeshResult call() throws Exception {
                CreateMeshResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeCreateMesh(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRouteResult> createRouteAsync(CreateRouteRequest request) {
        return this.createRouteAsync(request, null);
    }

    @Override
    public Future<CreateRouteResult> createRouteAsync(CreateRouteRequest request, final AsyncHandler<CreateRouteRequest, CreateRouteResult> asyncHandler) {
        final CreateRouteRequest finalRequest = (CreateRouteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRouteResult>(){

            @Override
            public CreateRouteResult call() throws Exception {
                CreateRouteResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeCreateRoute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVirtualNodeResult> createVirtualNodeAsync(CreateVirtualNodeRequest request) {
        return this.createVirtualNodeAsync(request, null);
    }

    @Override
    public Future<CreateVirtualNodeResult> createVirtualNodeAsync(CreateVirtualNodeRequest request, final AsyncHandler<CreateVirtualNodeRequest, CreateVirtualNodeResult> asyncHandler) {
        final CreateVirtualNodeRequest finalRequest = (CreateVirtualNodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVirtualNodeResult>(){

            @Override
            public CreateVirtualNodeResult call() throws Exception {
                CreateVirtualNodeResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeCreateVirtualNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVirtualRouterResult> createVirtualRouterAsync(CreateVirtualRouterRequest request) {
        return this.createVirtualRouterAsync(request, null);
    }

    @Override
    public Future<CreateVirtualRouterResult> createVirtualRouterAsync(CreateVirtualRouterRequest request, final AsyncHandler<CreateVirtualRouterRequest, CreateVirtualRouterResult> asyncHandler) {
        final CreateVirtualRouterRequest finalRequest = (CreateVirtualRouterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVirtualRouterResult>(){

            @Override
            public CreateVirtualRouterResult call() throws Exception {
                CreateVirtualRouterResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeCreateVirtualRouter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVirtualServiceResult> createVirtualServiceAsync(CreateVirtualServiceRequest request) {
        return this.createVirtualServiceAsync(request, null);
    }

    @Override
    public Future<CreateVirtualServiceResult> createVirtualServiceAsync(CreateVirtualServiceRequest request, final AsyncHandler<CreateVirtualServiceRequest, CreateVirtualServiceResult> asyncHandler) {
        final CreateVirtualServiceRequest finalRequest = (CreateVirtualServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVirtualServiceResult>(){

            @Override
            public CreateVirtualServiceResult call() throws Exception {
                CreateVirtualServiceResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeCreateVirtualService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMeshResult> deleteMeshAsync(DeleteMeshRequest request) {
        return this.deleteMeshAsync(request, null);
    }

    @Override
    public Future<DeleteMeshResult> deleteMeshAsync(DeleteMeshRequest request, final AsyncHandler<DeleteMeshRequest, DeleteMeshResult> asyncHandler) {
        final DeleteMeshRequest finalRequest = (DeleteMeshRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMeshResult>(){

            @Override
            public DeleteMeshResult call() throws Exception {
                DeleteMeshResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDeleteMesh(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRouteResult> deleteRouteAsync(DeleteRouteRequest request) {
        return this.deleteRouteAsync(request, null);
    }

    @Override
    public Future<DeleteRouteResult> deleteRouteAsync(DeleteRouteRequest request, final AsyncHandler<DeleteRouteRequest, DeleteRouteResult> asyncHandler) {
        final DeleteRouteRequest finalRequest = (DeleteRouteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRouteResult>(){

            @Override
            public DeleteRouteResult call() throws Exception {
                DeleteRouteResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDeleteRoute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualNodeResult> deleteVirtualNodeAsync(DeleteVirtualNodeRequest request) {
        return this.deleteVirtualNodeAsync(request, null);
    }

    @Override
    public Future<DeleteVirtualNodeResult> deleteVirtualNodeAsync(DeleteVirtualNodeRequest request, final AsyncHandler<DeleteVirtualNodeRequest, DeleteVirtualNodeResult> asyncHandler) {
        final DeleteVirtualNodeRequest finalRequest = (DeleteVirtualNodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVirtualNodeResult>(){

            @Override
            public DeleteVirtualNodeResult call() throws Exception {
                DeleteVirtualNodeResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDeleteVirtualNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualRouterResult> deleteVirtualRouterAsync(DeleteVirtualRouterRequest request) {
        return this.deleteVirtualRouterAsync(request, null);
    }

    @Override
    public Future<DeleteVirtualRouterResult> deleteVirtualRouterAsync(DeleteVirtualRouterRequest request, final AsyncHandler<DeleteVirtualRouterRequest, DeleteVirtualRouterResult> asyncHandler) {
        final DeleteVirtualRouterRequest finalRequest = (DeleteVirtualRouterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVirtualRouterResult>(){

            @Override
            public DeleteVirtualRouterResult call() throws Exception {
                DeleteVirtualRouterResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDeleteVirtualRouter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualServiceResult> deleteVirtualServiceAsync(DeleteVirtualServiceRequest request) {
        return this.deleteVirtualServiceAsync(request, null);
    }

    @Override
    public Future<DeleteVirtualServiceResult> deleteVirtualServiceAsync(DeleteVirtualServiceRequest request, final AsyncHandler<DeleteVirtualServiceRequest, DeleteVirtualServiceResult> asyncHandler) {
        final DeleteVirtualServiceRequest finalRequest = (DeleteVirtualServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVirtualServiceResult>(){

            @Override
            public DeleteVirtualServiceResult call() throws Exception {
                DeleteVirtualServiceResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDeleteVirtualService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMeshResult> describeMeshAsync(DescribeMeshRequest request) {
        return this.describeMeshAsync(request, null);
    }

    @Override
    public Future<DescribeMeshResult> describeMeshAsync(DescribeMeshRequest request, final AsyncHandler<DescribeMeshRequest, DescribeMeshResult> asyncHandler) {
        final DescribeMeshRequest finalRequest = (DescribeMeshRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMeshResult>(){

            @Override
            public DescribeMeshResult call() throws Exception {
                DescribeMeshResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDescribeMesh(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRouteResult> describeRouteAsync(DescribeRouteRequest request) {
        return this.describeRouteAsync(request, null);
    }

    @Override
    public Future<DescribeRouteResult> describeRouteAsync(DescribeRouteRequest request, final AsyncHandler<DescribeRouteRequest, DescribeRouteResult> asyncHandler) {
        final DescribeRouteRequest finalRequest = (DescribeRouteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRouteResult>(){

            @Override
            public DescribeRouteResult call() throws Exception {
                DescribeRouteResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDescribeRoute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualNodeResult> describeVirtualNodeAsync(DescribeVirtualNodeRequest request) {
        return this.describeVirtualNodeAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualNodeResult> describeVirtualNodeAsync(DescribeVirtualNodeRequest request, final AsyncHandler<DescribeVirtualNodeRequest, DescribeVirtualNodeResult> asyncHandler) {
        final DescribeVirtualNodeRequest finalRequest = (DescribeVirtualNodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVirtualNodeResult>(){

            @Override
            public DescribeVirtualNodeResult call() throws Exception {
                DescribeVirtualNodeResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDescribeVirtualNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualRouterResult> describeVirtualRouterAsync(DescribeVirtualRouterRequest request) {
        return this.describeVirtualRouterAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualRouterResult> describeVirtualRouterAsync(DescribeVirtualRouterRequest request, final AsyncHandler<DescribeVirtualRouterRequest, DescribeVirtualRouterResult> asyncHandler) {
        final DescribeVirtualRouterRequest finalRequest = (DescribeVirtualRouterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVirtualRouterResult>(){

            @Override
            public DescribeVirtualRouterResult call() throws Exception {
                DescribeVirtualRouterResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDescribeVirtualRouter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualServiceResult> describeVirtualServiceAsync(DescribeVirtualServiceRequest request) {
        return this.describeVirtualServiceAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualServiceResult> describeVirtualServiceAsync(DescribeVirtualServiceRequest request, final AsyncHandler<DescribeVirtualServiceRequest, DescribeVirtualServiceResult> asyncHandler) {
        final DescribeVirtualServiceRequest finalRequest = (DescribeVirtualServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVirtualServiceResult>(){

            @Override
            public DescribeVirtualServiceResult call() throws Exception {
                DescribeVirtualServiceResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeDescribeVirtualService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMeshesResult> listMeshesAsync(ListMeshesRequest request) {
        return this.listMeshesAsync(request, null);
    }

    @Override
    public Future<ListMeshesResult> listMeshesAsync(ListMeshesRequest request, final AsyncHandler<ListMeshesRequest, ListMeshesResult> asyncHandler) {
        final ListMeshesRequest finalRequest = (ListMeshesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMeshesResult>(){

            @Override
            public ListMeshesResult call() throws Exception {
                ListMeshesResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeListMeshes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRoutesResult> listRoutesAsync(ListRoutesRequest request) {
        return this.listRoutesAsync(request, null);
    }

    @Override
    public Future<ListRoutesResult> listRoutesAsync(ListRoutesRequest request, final AsyncHandler<ListRoutesRequest, ListRoutesResult> asyncHandler) {
        final ListRoutesRequest finalRequest = (ListRoutesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRoutesResult>(){

            @Override
            public ListRoutesResult call() throws Exception {
                ListRoutesResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeListRoutes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVirtualNodesResult> listVirtualNodesAsync(ListVirtualNodesRequest request) {
        return this.listVirtualNodesAsync(request, null);
    }

    @Override
    public Future<ListVirtualNodesResult> listVirtualNodesAsync(ListVirtualNodesRequest request, final AsyncHandler<ListVirtualNodesRequest, ListVirtualNodesResult> asyncHandler) {
        final ListVirtualNodesRequest finalRequest = (ListVirtualNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVirtualNodesResult>(){

            @Override
            public ListVirtualNodesResult call() throws Exception {
                ListVirtualNodesResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeListVirtualNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVirtualRoutersResult> listVirtualRoutersAsync(ListVirtualRoutersRequest request) {
        return this.listVirtualRoutersAsync(request, null);
    }

    @Override
    public Future<ListVirtualRoutersResult> listVirtualRoutersAsync(ListVirtualRoutersRequest request, final AsyncHandler<ListVirtualRoutersRequest, ListVirtualRoutersResult> asyncHandler) {
        final ListVirtualRoutersRequest finalRequest = (ListVirtualRoutersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVirtualRoutersResult>(){

            @Override
            public ListVirtualRoutersResult call() throws Exception {
                ListVirtualRoutersResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeListVirtualRouters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVirtualServicesResult> listVirtualServicesAsync(ListVirtualServicesRequest request) {
        return this.listVirtualServicesAsync(request, null);
    }

    @Override
    public Future<ListVirtualServicesResult> listVirtualServicesAsync(ListVirtualServicesRequest request, final AsyncHandler<ListVirtualServicesRequest, ListVirtualServicesResult> asyncHandler) {
        final ListVirtualServicesRequest finalRequest = (ListVirtualServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVirtualServicesResult>(){

            @Override
            public ListVirtualServicesResult call() throws Exception {
                ListVirtualServicesResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeListVirtualServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRouteResult> updateRouteAsync(UpdateRouteRequest request) {
        return this.updateRouteAsync(request, null);
    }

    @Override
    public Future<UpdateRouteResult> updateRouteAsync(UpdateRouteRequest request, final AsyncHandler<UpdateRouteRequest, UpdateRouteResult> asyncHandler) {
        final UpdateRouteRequest finalRequest = (UpdateRouteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRouteResult>(){

            @Override
            public UpdateRouteResult call() throws Exception {
                UpdateRouteResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeUpdateRoute(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVirtualNodeResult> updateVirtualNodeAsync(UpdateVirtualNodeRequest request) {
        return this.updateVirtualNodeAsync(request, null);
    }

    @Override
    public Future<UpdateVirtualNodeResult> updateVirtualNodeAsync(UpdateVirtualNodeRequest request, final AsyncHandler<UpdateVirtualNodeRequest, UpdateVirtualNodeResult> asyncHandler) {
        final UpdateVirtualNodeRequest finalRequest = (UpdateVirtualNodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVirtualNodeResult>(){

            @Override
            public UpdateVirtualNodeResult call() throws Exception {
                UpdateVirtualNodeResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeUpdateVirtualNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVirtualRouterResult> updateVirtualRouterAsync(UpdateVirtualRouterRequest request) {
        return this.updateVirtualRouterAsync(request, null);
    }

    @Override
    public Future<UpdateVirtualRouterResult> updateVirtualRouterAsync(UpdateVirtualRouterRequest request, final AsyncHandler<UpdateVirtualRouterRequest, UpdateVirtualRouterResult> asyncHandler) {
        final UpdateVirtualRouterRequest finalRequest = (UpdateVirtualRouterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVirtualRouterResult>(){

            @Override
            public UpdateVirtualRouterResult call() throws Exception {
                UpdateVirtualRouterResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeUpdateVirtualRouter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVirtualServiceResult> updateVirtualServiceAsync(UpdateVirtualServiceRequest request) {
        return this.updateVirtualServiceAsync(request, null);
    }

    @Override
    public Future<UpdateVirtualServiceResult> updateVirtualServiceAsync(UpdateVirtualServiceRequest request, final AsyncHandler<UpdateVirtualServiceRequest, UpdateVirtualServiceResult> asyncHandler) {
        final UpdateVirtualServiceRequest finalRequest = (UpdateVirtualServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVirtualServiceResult>(){

            @Override
            public UpdateVirtualServiceResult call() throws Exception {
                UpdateVirtualServiceResult result = null;
                try {
                    result = AWSAppMeshAsyncClient.this.executeUpdateVirtualService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

