/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appmesh.model.MeshData;

@SdkInternalApi
public class MeshDataMarshaller {
    private static final MarshallingInfo<String> MESHNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("meshName").build();
    private static final MarshallingInfo<StructuredPojo> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadata").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MeshDataMarshaller instance = new MeshDataMarshaller();

    public static MeshDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(MeshData meshData, ProtocolMarshaller protocolMarshaller) {
        if (meshData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)meshData.getMeshName(), MESHNAME_BINDING);
            protocolMarshaller.marshall((Object)meshData.getMetadata(), METADATA_BINDING);
            protocolMarshaller.marshall((Object)meshData.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

