/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationautoscaling.model.ScalingPolicy;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ScalingPolicyMarshaller {
    private static final MarshallingInfo<String> POLICYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyARN").build();
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyName").build();
    private static final MarshallingInfo<String> SERVICENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceNamespace").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> SCALABLEDIMENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalableDimension").build();
    private static final MarshallingInfo<String> POLICYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyType").build();
    private static final MarshallingInfo<StructuredPojo> STEPSCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepScalingPolicyConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTrackingScalingPolicyConfiguration").build();
    private static final MarshallingInfo<List> ALARMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alarms").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final ScalingPolicyMarshaller instance = new ScalingPolicyMarshaller();

    public static ScalingPolicyMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalingPolicy scalingPolicy, ProtocolMarshaller protocolMarshaller) {
        if (scalingPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalingPolicy.getPolicyARN(), POLICYARN_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getPolicyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getServiceNamespace(), SERVICENAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getScalableDimension(), SCALABLEDIMENSION_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getPolicyType(), POLICYTYPE_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getStepScalingPolicyConfiguration(), STEPSCALINGPOLICYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getTargetTrackingScalingPolicyConfiguration(), TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING);
            protocolMarshaller.marshall(scalingPolicy.getAlarms(), ALARMS_BINDING);
            protocolMarshaller.marshall((Object)scalingPolicy.getCreationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

