/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.AggregationConfig;
import com.amazonaws.services.appflow.model.FileType;
import com.amazonaws.services.appflow.model.PrefixConfig;
import com.amazonaws.services.appflow.model.transform.S3OutputFormatConfigMarshaller;
import java.io.Serializable;

public class S3OutputFormatConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileType;
    private PrefixConfig prefixConfig;
    private AggregationConfig aggregationConfig;
    private Boolean preserveSourceDataTyping;

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public S3OutputFormatConfig withFileType(String fileType) {
        this.setFileType(fileType);
        return this;
    }

    public S3OutputFormatConfig withFileType(FileType fileType) {
        this.fileType = fileType.toString();
        return this;
    }

    public void setPrefixConfig(PrefixConfig prefixConfig) {
        this.prefixConfig = prefixConfig;
    }

    public PrefixConfig getPrefixConfig() {
        return this.prefixConfig;
    }

    public S3OutputFormatConfig withPrefixConfig(PrefixConfig prefixConfig) {
        this.setPrefixConfig(prefixConfig);
        return this;
    }

    public void setAggregationConfig(AggregationConfig aggregationConfig) {
        this.aggregationConfig = aggregationConfig;
    }

    public AggregationConfig getAggregationConfig() {
        return this.aggregationConfig;
    }

    public S3OutputFormatConfig withAggregationConfig(AggregationConfig aggregationConfig) {
        this.setAggregationConfig(aggregationConfig);
        return this;
    }

    public void setPreserveSourceDataTyping(Boolean preserveSourceDataTyping) {
        this.preserveSourceDataTyping = preserveSourceDataTyping;
    }

    public Boolean getPreserveSourceDataTyping() {
        return this.preserveSourceDataTyping;
    }

    public S3OutputFormatConfig withPreserveSourceDataTyping(Boolean preserveSourceDataTyping) {
        this.setPreserveSourceDataTyping(preserveSourceDataTyping);
        return this;
    }

    public Boolean isPreserveSourceDataTyping() {
        return this.preserveSourceDataTyping;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileType() != null) {
            sb.append("FileType: ").append(this.getFileType()).append(",");
        }
        if (this.getPrefixConfig() != null) {
            sb.append("PrefixConfig: ").append(this.getPrefixConfig()).append(",");
        }
        if (this.getAggregationConfig() != null) {
            sb.append("AggregationConfig: ").append(this.getAggregationConfig()).append(",");
        }
        if (this.getPreserveSourceDataTyping() != null) {
            sb.append("PreserveSourceDataTyping: ").append(this.getPreserveSourceDataTyping());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputFormatConfig)) {
            return false;
        }
        S3OutputFormatConfig other = (S3OutputFormatConfig)obj;
        if (other.getFileType() == null ^ this.getFileType() == null) {
            return false;
        }
        if (other.getFileType() != null && !other.getFileType().equals(this.getFileType())) {
            return false;
        }
        if (other.getPrefixConfig() == null ^ this.getPrefixConfig() == null) {
            return false;
        }
        if (other.getPrefixConfig() != null && !other.getPrefixConfig().equals(this.getPrefixConfig())) {
            return false;
        }
        if (other.getAggregationConfig() == null ^ this.getAggregationConfig() == null) {
            return false;
        }
        if (other.getAggregationConfig() != null && !other.getAggregationConfig().equals(this.getAggregationConfig())) {
            return false;
        }
        if (other.getPreserveSourceDataTyping() == null ^ this.getPreserveSourceDataTyping() == null) {
            return false;
        }
        return other.getPreserveSourceDataTyping() == null || other.getPreserveSourceDataTyping().equals(this.getPreserveSourceDataTyping());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileType() == null ? 0 : this.getFileType().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixConfig() == null ? 0 : this.getPrefixConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationConfig() == null ? 0 : this.getAggregationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getPreserveSourceDataTyping() == null ? 0 : this.getPreserveSourceDataTyping().hashCode());
        return hashCode;
    }

    public S3OutputFormatConfig clone() {
        try {
            return (S3OutputFormatConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3OutputFormatConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

