/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.OAuth2Credentials;

@SdkInternalApi
public class OAuth2CredentialsMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").build();
    private static final MarshallingInfo<String> CLIENTSECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientSecret").build();
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessToken").build();
    private static final MarshallingInfo<String> REFRESHTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("refreshToken").build();
    private static final MarshallingInfo<StructuredPojo> OAUTHREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oAuthRequest").build();
    private static final OAuth2CredentialsMarshaller instance = new OAuth2CredentialsMarshaller();

    public static OAuth2CredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(OAuth2Credentials oAuth2Credentials, ProtocolMarshaller protocolMarshaller) {
        if (oAuth2Credentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oAuth2Credentials.getClientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)oAuth2Credentials.getClientSecret(), CLIENTSECRET_BINDING);
            protocolMarshaller.marshall((Object)oAuth2Credentials.getAccessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall((Object)oAuth2Credentials.getRefreshToken(), REFRESHTOKEN_BINDING);
            protocolMarshaller.marshall((Object)oAuth2Credentials.getOAuthRequest(), OAUTHREQUEST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

