/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appconfig.model.Action;
import com.amazonaws.services.appconfig.model.Parameter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateExtensionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String extensionIdentifier;
    private String description;
    private Map<String, List<Action>> actions;
    private Map<String, Parameter> parameters;
    private Integer versionNumber;

    public void setExtensionIdentifier(String extensionIdentifier) {
        this.extensionIdentifier = extensionIdentifier;
    }

    public String getExtensionIdentifier() {
        return this.extensionIdentifier;
    }

    public UpdateExtensionRequest withExtensionIdentifier(String extensionIdentifier) {
        this.setExtensionIdentifier(extensionIdentifier);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateExtensionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, List<Action>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, List<Action>> actions) {
        this.actions = actions;
    }

    public UpdateExtensionRequest withActions(Map<String, List<Action>> actions) {
        this.setActions(actions);
        return this;
    }

    public UpdateExtensionRequest addActionsEntry(String key, List<Action> value) {
        if (null == this.actions) {
            this.actions = new HashMap<String, List<Action>>();
        }
        if (this.actions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.actions.put(key, value);
        return this;
    }

    public UpdateExtensionRequest clearActionsEntries() {
        this.actions = null;
        return this;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public UpdateExtensionRequest withParameters(Map<String, Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public UpdateExtensionRequest addParametersEntry(String key, Parameter value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, Parameter>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public UpdateExtensionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public UpdateExtensionRequest withVersionNumber(Integer versionNumber) {
        this.setVersionNumber(versionNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExtensionIdentifier() != null) {
            sb.append("ExtensionIdentifier: ").append(this.getExtensionIdentifier()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getVersionNumber() != null) {
            sb.append("VersionNumber: ").append(this.getVersionNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExtensionRequest)) {
            return false;
        }
        UpdateExtensionRequest other = (UpdateExtensionRequest)obj;
        if (other.getExtensionIdentifier() == null ^ this.getExtensionIdentifier() == null) {
            return false;
        }
        if (other.getExtensionIdentifier() != null && !other.getExtensionIdentifier().equals(this.getExtensionIdentifier())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getVersionNumber() == null ^ this.getVersionNumber() == null) {
            return false;
        }
        return other.getVersionNumber() == null || other.getVersionNumber().equals(this.getVersionNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExtensionIdentifier() == null ? 0 : this.getExtensionIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getVersionNumber() == null ? 0 : this.getVersionNumber().hashCode());
        return hashCode;
    }

    public UpdateExtensionRequest clone() {
        return (UpdateExtensionRequest)super.clone();
    }
}

