/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apigateway.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Represents an AWS account that is associated with API Gateway.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetAccountResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of an Amazon CloudWatch role for the current Account.
     * </p>
     */
    private String cloudwatchRoleArn;
    /**
     * <p>
     * Specifies the API request limits configured for the current Account.
     * </p>
     */
    private ThrottleSettings throttleSettings;
    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     */
    private java.util.List<String> features;
    /**
     * <p>
     * The version of the API keys used for the account.
     * </p>
     */
    private String apiKeyVersion;

    /**
     * <p>
     * The ARN of an Amazon CloudWatch role for the current Account.
     * </p>
     * 
     * @param cloudwatchRoleArn
     *        The ARN of an Amazon CloudWatch role for the current Account.
     */

    public void setCloudwatchRoleArn(String cloudwatchRoleArn) {
        this.cloudwatchRoleArn = cloudwatchRoleArn;
    }

    /**
     * <p>
     * The ARN of an Amazon CloudWatch role for the current Account.
     * </p>
     * 
     * @return The ARN of an Amazon CloudWatch role for the current Account.
     */

    public String getCloudwatchRoleArn() {
        return this.cloudwatchRoleArn;
    }

    /**
     * <p>
     * The ARN of an Amazon CloudWatch role for the current Account.
     * </p>
     * 
     * @param cloudwatchRoleArn
     *        The ARN of an Amazon CloudWatch role for the current Account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAccountResult withCloudwatchRoleArn(String cloudwatchRoleArn) {
        setCloudwatchRoleArn(cloudwatchRoleArn);
        return this;
    }

    /**
     * <p>
     * Specifies the API request limits configured for the current Account.
     * </p>
     * 
     * @param throttleSettings
     *        Specifies the API request limits configured for the current Account.
     */

    public void setThrottleSettings(ThrottleSettings throttleSettings) {
        this.throttleSettings = throttleSettings;
    }

    /**
     * <p>
     * Specifies the API request limits configured for the current Account.
     * </p>
     * 
     * @return Specifies the API request limits configured for the current Account.
     */

    public ThrottleSettings getThrottleSettings() {
        return this.throttleSettings;
    }

    /**
     * <p>
     * Specifies the API request limits configured for the current Account.
     * </p>
     * 
     * @param throttleSettings
     *        Specifies the API request limits configured for the current Account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAccountResult withThrottleSettings(ThrottleSettings throttleSettings) {
        setThrottleSettings(throttleSettings);
        return this;
    }

    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     * 
     * @return A list of features supported for the account. When usage plans are enabled, the features list will
     *         include an entry of <code>"UsagePlans"</code>.
     */

    public java.util.List<String> getFeatures() {
        return features;
    }

    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     * 
     * @param features
     *        A list of features supported for the account. When usage plans are enabled, the features list will include
     *        an entry of <code>"UsagePlans"</code>.
     */

    public void setFeatures(java.util.Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }

        this.features = new java.util.ArrayList<String>(features);
    }

    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFeatures(java.util.Collection)} or {@link #withFeatures(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param features
     *        A list of features supported for the account. When usage plans are enabled, the features list will include
     *        an entry of <code>"UsagePlans"</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAccountResult withFeatures(String... features) {
        if (this.features == null) {
            setFeatures(new java.util.ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of features supported for the account. When usage plans are enabled, the features list will include an
     * entry of <code>"UsagePlans"</code>.
     * </p>
     * 
     * @param features
     *        A list of features supported for the account. When usage plans are enabled, the features list will include
     *        an entry of <code>"UsagePlans"</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAccountResult withFeatures(java.util.Collection<String> features) {
        setFeatures(features);
        return this;
    }

    /**
     * <p>
     * The version of the API keys used for the account.
     * </p>
     * 
     * @param apiKeyVersion
     *        The version of the API keys used for the account.
     */

    public void setApiKeyVersion(String apiKeyVersion) {
        this.apiKeyVersion = apiKeyVersion;
    }

    /**
     * <p>
     * The version of the API keys used for the account.
     * </p>
     * 
     * @return The version of the API keys used for the account.
     */

    public String getApiKeyVersion() {
        return this.apiKeyVersion;
    }

    /**
     * <p>
     * The version of the API keys used for the account.
     * </p>
     * 
     * @param apiKeyVersion
     *        The version of the API keys used for the account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAccountResult withApiKeyVersion(String apiKeyVersion) {
        setApiKeyVersion(apiKeyVersion);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCloudwatchRoleArn() != null)
            sb.append("CloudwatchRoleArn: ").append(getCloudwatchRoleArn()).append(",");
        if (getThrottleSettings() != null)
            sb.append("ThrottleSettings: ").append(getThrottleSettings()).append(",");
        if (getFeatures() != null)
            sb.append("Features: ").append(getFeatures()).append(",");
        if (getApiKeyVersion() != null)
            sb.append("ApiKeyVersion: ").append(getApiKeyVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetAccountResult == false)
            return false;
        GetAccountResult other = (GetAccountResult) obj;
        if (other.getCloudwatchRoleArn() == null ^ this.getCloudwatchRoleArn() == null)
            return false;
        if (other.getCloudwatchRoleArn() != null && other.getCloudwatchRoleArn().equals(this.getCloudwatchRoleArn()) == false)
            return false;
        if (other.getThrottleSettings() == null ^ this.getThrottleSettings() == null)
            return false;
        if (other.getThrottleSettings() != null && other.getThrottleSettings().equals(this.getThrottleSettings()) == false)
            return false;
        if (other.getFeatures() == null ^ this.getFeatures() == null)
            return false;
        if (other.getFeatures() != null && other.getFeatures().equals(this.getFeatures()) == false)
            return false;
        if (other.getApiKeyVersion() == null ^ this.getApiKeyVersion() == null)
            return false;
        if (other.getApiKeyVersion() != null && other.getApiKeyVersion().equals(this.getApiKeyVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCloudwatchRoleArn() == null) ? 0 : getCloudwatchRoleArn().hashCode());
        hashCode = prime * hashCode + ((getThrottleSettings() == null) ? 0 : getThrottleSettings().hashCode());
        hashCode = prime * hashCode + ((getFeatures() == null) ? 0 : getFeatures().hashCode());
        hashCode = prime * hashCode + ((getApiKeyVersion() == null) ? 0 : getApiKeyVersion().hashCode());
        return hashCode;
    }

    @Override
    public GetAccountResult clone() {
        try {
            return (GetAccountResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
