/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeploymentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/deployments";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createDeploymentRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createDeploymentRequest.getRestApiId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> variablesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeploymentRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(createDeploymentRequest.getStageName());
            }
            if (createDeploymentRequest.getStageDescription() != null) {
                jsonGenerator.writeFieldName("stageDescription").writeValue(createDeploymentRequest.getStageDescription());
            }
            if (createDeploymentRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createDeploymentRequest.getDescription());
            }
            if (createDeploymentRequest.getCacheClusterEnabled() != null) {
                jsonGenerator.writeFieldName("cacheClusterEnabled").writeValue(createDeploymentRequest.getCacheClusterEnabled().booleanValue());
            }
            if (createDeploymentRequest.getCacheClusterSize() != null) {
                jsonGenerator.writeFieldName("cacheClusterSize").writeValue(createDeploymentRequest.getCacheClusterSize());
            }
            if ((variablesMap = createDeploymentRequest.getVariables()) != null) {
                jsonGenerator.writeFieldName("variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(variablesMapValue.getKey());
                    jsonGenerator.writeValue(variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

