/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetBasePathMappingRequestMarshaller
implements Marshaller<Request<GetBasePathMappingRequest>, GetBasePathMappingRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetBasePathMappingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetBasePathMappingRequest> marshall(GetBasePathMappingRequest getBasePathMappingRequest) {
        if (getBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getBasePathMappingRequest.getDomainName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getBasePathMappingRequest.getDomainName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{base_path}", getBasePathMappingRequest.getBasePath() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getBasePathMappingRequest.getBasePath()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

