/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetExportRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class GetExportRequestMarshaller
implements Marshaller<Request<GetExportRequest>, GetExportRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetExportRequest> marshall(GetExportRequest getExportRequest) {
        if (getExportRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getExportRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        if (getExportRequest.getAccepts() != null) {
            request.addHeader("Accept", StringUtils.fromString((String)getExportRequest.getAccepts()));
        }
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/exports/{export_type}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getExportRequest.getRestApiId() != null ? StringUtils.fromString((String)getExportRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{stage_name}", getExportRequest.getStageName() != null ? StringUtils.fromString((String)getExportRequest.getStageName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{export_type}", getExportRequest.getExportType() != null ? StringUtils.fromString((String)getExportRequest.getExportType()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        Map<String, String> parameters = getExportRequest.getParameters();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString((String)entry.getKey()), StringUtils.fromString((String)entry.getValue()));
            }
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

