/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.RestApi;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class RestApiJsonMarshaller {
    private static RestApiJsonMarshaller instance;

    public void marshall(RestApi restApi, StructuredJsonGenerator jsonGenerator) {
        if (restApi == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> warningsList;
            jsonGenerator.writeStartObject();
            if (restApi.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(restApi.getId());
            }
            if (restApi.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(restApi.getName());
            }
            if (restApi.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(restApi.getDescription());
            }
            if (restApi.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(restApi.getCreatedDate());
            }
            if ((warningsList = restApi.getWarnings()) != null) {
                jsonGenerator.writeFieldName("warnings");
                jsonGenerator.writeStartArray();
                for (String warningsListValue : warningsList) {
                    if (warningsListValue == null) continue;
                    jsonGenerator.writeValue(warningsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RestApiJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RestApiJsonMarshaller();
        }
        return instance;
    }
}

