/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetDomainNamesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDomainNamesRequestMarshaller
implements Marshaller<Request<GetDomainNamesRequest>, GetDomainNamesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetDomainNamesRequest> marshall(GetDomainNamesRequest getDomainNamesRequest) {
        if (getDomainNamesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDomainNamesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames";
        request.setResourcePath(uriResourcePath);
        if (getDomainNamesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getDomainNamesRequest.getPosition()));
        }
        if (getDomainNamesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getDomainNamesRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

