/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.FlushStageCacheRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class FlushStageCacheRequestMarshaller
implements Marshaller<Request<FlushStageCacheRequest>, FlushStageCacheRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<FlushStageCacheRequest> marshall(FlushStageCacheRequest flushStageCacheRequest) {
        if (flushStageCacheRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)flushStageCacheRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/cache/data";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", flushStageCacheRequest.getRestApiId() != null ? StringUtils.fromString((String)flushStageCacheRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{stage_name}", flushStageCacheRequest.getStageName() != null ? StringUtils.fromString((String)flushStageCacheRequest.getStageName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

