/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetClientCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetClientCertificatesRequestMarshaller
implements Marshaller<Request<GetClientCertificatesRequest>, GetClientCertificatesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetClientCertificatesRequest> marshall(GetClientCertificatesRequest getClientCertificatesRequest) {
        if (getClientCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getClientCertificatesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/clientcertificates";
        request.setResourcePath(uriResourcePath);
        if (getClientCertificatesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getClientCertificatesRequest.getPosition()));
        }
        if (getClientCertificatesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getClientCertificatesRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

