/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.TestInvokeAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class TestInvokeAuthorizerRequestMarshaller
implements Marshaller<Request<TestInvokeAuthorizerRequest>, TestInvokeAuthorizerRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<TestInvokeAuthorizerRequest> marshall(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        if (testInvokeAuthorizerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testInvokeAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers/{authorizer_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", testInvokeAuthorizerRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)testInvokeAuthorizerRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{authorizer_id}", testInvokeAuthorizerRequest.getAuthorizerId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)testInvokeAuthorizerRequest.getAuthorizerId()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> additionalContextMap;
            Map<String, String> stageVariablesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            Map<String, String> headersMap = testInvokeAuthorizerRequest.getHeaders();
            if (headersMap != null) {
                jsonWriter.key("headers");
                jsonWriter.object();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonWriter.key(headersMapValue.getKey());
                    jsonWriter.value((Object)headersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (testInvokeAuthorizerRequest.getPathWithQueryString() != null) {
                jsonWriter.key("pathWithQueryString").value((Object)testInvokeAuthorizerRequest.getPathWithQueryString());
            }
            if (testInvokeAuthorizerRequest.getBody() != null) {
                jsonWriter.key("body").value((Object)testInvokeAuthorizerRequest.getBody());
            }
            if ((stageVariablesMap = testInvokeAuthorizerRequest.getStageVariables()) != null) {
                jsonWriter.key("stageVariables");
                jsonWriter.object();
                for (Map.Entry<String, String> stageVariablesMapValue : stageVariablesMap.entrySet()) {
                    if (stageVariablesMapValue.getValue() == null) continue;
                    jsonWriter.key(stageVariablesMapValue.getKey());
                    jsonWriter.value((Object)stageVariablesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((additionalContextMap = testInvokeAuthorizerRequest.getAdditionalContext()) != null) {
                jsonWriter.key("additionalContext");
                jsonWriter.object();
                for (Map.Entry<String, String> additionalContextMapValue : additionalContextMap.entrySet()) {
                    if (additionalContextMapValue.getValue() == null) continue;
                    jsonWriter.key(additionalContextMapValue.getKey());
                    jsonWriter.value((Object)additionalContextMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

