/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateRestApiRequestMarshaller
implements Marshaller<Request<CreateRestApiRequest>, CreateRestApiRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreateRestApiRequest> marshall(CreateRestApiRequest createRestApiRequest) {
        if (createRestApiRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createRestApiRequest.getName() != null) {
                jsonWriter.key("name").value((Object)createRestApiRequest.getName());
            }
            if (createRestApiRequest.getDescription() != null) {
                jsonWriter.key("description").value((Object)createRestApiRequest.getDescription());
            }
            if (createRestApiRequest.getCloneFrom() != null) {
                jsonWriter.key("cloneFrom").value((Object)createRestApiRequest.getCloneFrom());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

