/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PutMethodRequestMarshaller
implements Marshaller<Request<PutMethodRequest>, PutMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<PutMethodRequest> marshall(PutMethodRequest putMethodRequest) {
        if (putMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> requestModelsMap;
            Map<String, Boolean> requestParametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (putMethodRequest.getAuthorizationType() != null) {
                jsonWriter.key("authorizationType").value((Object)putMethodRequest.getAuthorizationType());
            }
            if (putMethodRequest.getApiKeyRequired() != null) {
                jsonWriter.key("apiKeyRequired").value((Object)putMethodRequest.getApiKeyRequired());
            }
            if ((requestParametersMap = putMethodRequest.getRequestParameters()) != null) {
                jsonWriter.key("requestParameters");
                jsonWriter.object();
                for (Map.Entry<String, Boolean> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(requestParametersMapValue.getKey());
                    jsonWriter.value((Object)requestParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((requestModelsMap = putMethodRequest.getRequestModels()) != null) {
                jsonWriter.key("requestModels");
                jsonWriter.object();
                for (Map.Entry<String, String> requestModelsMapValue : requestModelsMap.entrySet()) {
                    if (requestModelsMapValue.getValue() == null) continue;
                    jsonWriter.key(requestModelsMapValue.getKey());
                    jsonWriter.value((Object)requestModelsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

