/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetStageRequestMarshaller
implements Marshaller<Request<GetStageRequest>, GetStageRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetStageRequest> marshall(GetStageRequest getStageRequest) {
        if (getStageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getStageRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getStageRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{stage_name}", getStageRequest.getStageName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getStageRequest.getStageName()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

