/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteBasePathMappingRequestMarshaller
implements Marshaller<Request<DeleteBasePathMappingRequest>, DeleteBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DeleteBasePathMappingRequest> marshall(DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        if (deleteBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", deleteBasePathMappingRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)deleteBasePathMappingRequest.getDomainName()));
        uriResourcePath = uriResourcePath.replace("{base_path}", deleteBasePathMappingRequest.getBasePath() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)deleteBasePathMappingRequest.getBasePath()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

