/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.ComponentBindingPropertiesValue;
import com.amazonaws.services.amplifyuibuilder.model.ComponentChild;
import com.amazonaws.services.amplifyuibuilder.model.ComponentDataConfiguration;
import com.amazonaws.services.amplifyuibuilder.model.ComponentEvent;
import com.amazonaws.services.amplifyuibuilder.model.ComponentProperty;
import com.amazonaws.services.amplifyuibuilder.model.ComponentVariant;
import com.amazonaws.services.amplifyuibuilder.model.transform.UpdateComponentDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateComponentData
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private String sourceId;
    private String componentType;
    private Map<String, ComponentProperty> properties;
    private List<ComponentChild> children;
    private List<ComponentVariant> variants;
    private Map<String, Map<String, String>> overrides;
    private Map<String, ComponentBindingPropertiesValue> bindingProperties;
    private Map<String, ComponentDataConfiguration> collectionProperties;
    private Map<String, ComponentEvent> events;
    private String schemaVersion;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public UpdateComponentData withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateComponentData withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public UpdateComponentData withSourceId(String sourceId) {
        this.setSourceId(sourceId);
        return this;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public UpdateComponentData withComponentType(String componentType) {
        this.setComponentType(componentType);
        return this;
    }

    public Map<String, ComponentProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ComponentProperty> properties) {
        this.properties = properties;
    }

    public UpdateComponentData withProperties(Map<String, ComponentProperty> properties) {
        this.setProperties(properties);
        return this;
    }

    public UpdateComponentData addPropertiesEntry(String key, ComponentProperty value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, ComponentProperty>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public UpdateComponentData clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public List<ComponentChild> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<ComponentChild> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<ComponentChild>(children);
    }

    public UpdateComponentData withChildren(ComponentChild ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<ComponentChild>(children.length));
        }
        for (ComponentChild ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public UpdateComponentData withChildren(Collection<ComponentChild> children) {
        this.setChildren(children);
        return this;
    }

    public List<ComponentVariant> getVariants() {
        return this.variants;
    }

    public void setVariants(Collection<ComponentVariant> variants) {
        if (variants == null) {
            this.variants = null;
            return;
        }
        this.variants = new ArrayList<ComponentVariant>(variants);
    }

    public UpdateComponentData withVariants(ComponentVariant ... variants) {
        if (this.variants == null) {
            this.setVariants(new ArrayList<ComponentVariant>(variants.length));
        }
        for (ComponentVariant ele : variants) {
            this.variants.add(ele);
        }
        return this;
    }

    public UpdateComponentData withVariants(Collection<ComponentVariant> variants) {
        this.setVariants(variants);
        return this;
    }

    public Map<String, Map<String, String>> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, Map<String, String>> overrides) {
        this.overrides = overrides;
    }

    public UpdateComponentData withOverrides(Map<String, Map<String, String>> overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public UpdateComponentData addOverridesEntry(String key, Map<String, String> value) {
        if (null == this.overrides) {
            this.overrides = new HashMap<String, Map<String, String>>();
        }
        if (this.overrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.overrides.put(key, value);
        return this;
    }

    public UpdateComponentData clearOverridesEntries() {
        this.overrides = null;
        return this;
    }

    public Map<String, ComponentBindingPropertiesValue> getBindingProperties() {
        return this.bindingProperties;
    }

    public void setBindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
        this.bindingProperties = bindingProperties;
    }

    public UpdateComponentData withBindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
        this.setBindingProperties(bindingProperties);
        return this;
    }

    public UpdateComponentData addBindingPropertiesEntry(String key, ComponentBindingPropertiesValue value) {
        if (null == this.bindingProperties) {
            this.bindingProperties = new HashMap<String, ComponentBindingPropertiesValue>();
        }
        if (this.bindingProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.bindingProperties.put(key, value);
        return this;
    }

    public UpdateComponentData clearBindingPropertiesEntries() {
        this.bindingProperties = null;
        return this;
    }

    public Map<String, ComponentDataConfiguration> getCollectionProperties() {
        return this.collectionProperties;
    }

    public void setCollectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
        this.collectionProperties = collectionProperties;
    }

    public UpdateComponentData withCollectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
        this.setCollectionProperties(collectionProperties);
        return this;
    }

    public UpdateComponentData addCollectionPropertiesEntry(String key, ComponentDataConfiguration value) {
        if (null == this.collectionProperties) {
            this.collectionProperties = new HashMap<String, ComponentDataConfiguration>();
        }
        if (this.collectionProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.collectionProperties.put(key, value);
        return this;
    }

    public UpdateComponentData clearCollectionPropertiesEntries() {
        this.collectionProperties = null;
        return this;
    }

    public Map<String, ComponentEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, ComponentEvent> events) {
        this.events = events;
    }

    public UpdateComponentData withEvents(Map<String, ComponentEvent> events) {
        this.setEvents(events);
        return this;
    }

    public UpdateComponentData addEventsEntry(String key, ComponentEvent value) {
        if (null == this.events) {
            this.events = new HashMap<String, ComponentEvent>();
        }
        if (this.events.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.events.put(key, value);
        return this;
    }

    public UpdateComponentData clearEventsEntries() {
        this.events = null;
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public UpdateComponentData withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSourceId() != null) {
            sb.append("SourceId: ").append(this.getSourceId()).append(",");
        }
        if (this.getComponentType() != null) {
            sb.append("ComponentType: ").append(this.getComponentType()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren()).append(",");
        }
        if (this.getVariants() != null) {
            sb.append("Variants: ").append(this.getVariants()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getBindingProperties() != null) {
            sb.append("BindingProperties: ").append(this.getBindingProperties()).append(",");
        }
        if (this.getCollectionProperties() != null) {
            sb.append("CollectionProperties: ").append(this.getCollectionProperties()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentData)) {
            return false;
        }
        UpdateComponentData other = (UpdateComponentData)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSourceId() == null ^ this.getSourceId() == null) {
            return false;
        }
        if (other.getSourceId() != null && !other.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        if (other.getComponentType() == null ^ this.getComponentType() == null) {
            return false;
        }
        if (other.getComponentType() != null && !other.getComponentType().equals(this.getComponentType())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        if (other.getChildren() != null && !other.getChildren().equals(this.getChildren())) {
            return false;
        }
        if (other.getVariants() == null ^ this.getVariants() == null) {
            return false;
        }
        if (other.getVariants() != null && !other.getVariants().equals(this.getVariants())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getBindingProperties() == null ^ this.getBindingProperties() == null) {
            return false;
        }
        if (other.getBindingProperties() != null && !other.getBindingProperties().equals(this.getBindingProperties())) {
            return false;
        }
        if (other.getCollectionProperties() == null ^ this.getCollectionProperties() == null) {
            return false;
        }
        if (other.getCollectionProperties() != null && !other.getCollectionProperties().equals(this.getCollectionProperties())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        return other.getSchemaVersion() == null || other.getSchemaVersion().equals(this.getSchemaVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceId() == null ? 0 : this.getSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentType() == null ? 0 : this.getComponentType().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        hashCode = 31 * hashCode + (this.getVariants() == null ? 0 : this.getVariants().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getBindingProperties() == null ? 0 : this.getBindingProperties().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionProperties() == null ? 0 : this.getCollectionProperties().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        return hashCode;
    }

    public UpdateComponentData clone() {
        try {
            return (UpdateComponentData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateComponentDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

