/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifybackend;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.amplifybackend.AWSAmplifyBackendAsync;
import com.amazonaws.services.amplifybackend.AWSAmplifyBackendAsyncClientBuilder;
import com.amazonaws.services.amplifybackend.AWSAmplifyBackendClient;
import com.amazonaws.services.amplifybackend.model.CloneBackendRequest;
import com.amazonaws.services.amplifybackend.model.CloneBackendResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendResult;
import com.amazonaws.services.amplifybackend.model.CreateTokenRequest;
import com.amazonaws.services.amplifybackend.model.CreateTokenResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendResult;
import com.amazonaws.services.amplifybackend.model.DeleteTokenRequest;
import com.amazonaws.services.amplifybackend.model.DeleteTokenResult;
import com.amazonaws.services.amplifybackend.model.GenerateBackendAPIModelsRequest;
import com.amazonaws.services.amplifybackend.model.GenerateBackendAPIModelsResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIModelsRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIModelsResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.GetBackendJobRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendJobResult;
import com.amazonaws.services.amplifybackend.model.GetBackendRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendResult;
import com.amazonaws.services.amplifybackend.model.GetTokenRequest;
import com.amazonaws.services.amplifybackend.model.GetTokenResult;
import com.amazonaws.services.amplifybackend.model.ListBackendJobsRequest;
import com.amazonaws.services.amplifybackend.model.ListBackendJobsResult;
import com.amazonaws.services.amplifybackend.model.RemoveAllBackendsRequest;
import com.amazonaws.services.amplifybackend.model.RemoveAllBackendsResult;
import com.amazonaws.services.amplifybackend.model.RemoveBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.RemoveBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendJobRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAmplifyBackendAsyncClient
extends AWSAmplifyBackendClient
implements AWSAmplifyBackendAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAmplifyBackendAsyncClientBuilder asyncBuilder() {
        return AWSAmplifyBackendAsyncClientBuilder.standard();
    }

    AWSAmplifyBackendAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAmplifyBackendAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CloneBackendResult> cloneBackendAsync(CloneBackendRequest request) {
        return this.cloneBackendAsync(request, null);
    }

    @Override
    public Future<CloneBackendResult> cloneBackendAsync(CloneBackendRequest request, final AsyncHandler<CloneBackendRequest, CloneBackendResult> asyncHandler) {
        final CloneBackendRequest finalRequest = (CloneBackendRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CloneBackendResult>(){

            @Override
            public CloneBackendResult call() throws Exception {
                CloneBackendResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCloneBackend(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackendResult> createBackendAsync(CreateBackendRequest request) {
        return this.createBackendAsync(request, null);
    }

    @Override
    public Future<CreateBackendResult> createBackendAsync(CreateBackendRequest request, final AsyncHandler<CreateBackendRequest, CreateBackendResult> asyncHandler) {
        final CreateBackendRequest finalRequest = (CreateBackendRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackendResult>(){

            @Override
            public CreateBackendResult call() throws Exception {
                CreateBackendResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCreateBackend(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackendAPIResult> createBackendAPIAsync(CreateBackendAPIRequest request) {
        return this.createBackendAPIAsync(request, null);
    }

    @Override
    public Future<CreateBackendAPIResult> createBackendAPIAsync(CreateBackendAPIRequest request, final AsyncHandler<CreateBackendAPIRequest, CreateBackendAPIResult> asyncHandler) {
        final CreateBackendAPIRequest finalRequest = (CreateBackendAPIRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackendAPIResult>(){

            @Override
            public CreateBackendAPIResult call() throws Exception {
                CreateBackendAPIResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCreateBackendAPI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackendAuthResult> createBackendAuthAsync(CreateBackendAuthRequest request) {
        return this.createBackendAuthAsync(request, null);
    }

    @Override
    public Future<CreateBackendAuthResult> createBackendAuthAsync(CreateBackendAuthRequest request, final AsyncHandler<CreateBackendAuthRequest, CreateBackendAuthResult> asyncHandler) {
        final CreateBackendAuthRequest finalRequest = (CreateBackendAuthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackendAuthResult>(){

            @Override
            public CreateBackendAuthResult call() throws Exception {
                CreateBackendAuthResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCreateBackendAuth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackendConfigResult> createBackendConfigAsync(CreateBackendConfigRequest request) {
        return this.createBackendConfigAsync(request, null);
    }

    @Override
    public Future<CreateBackendConfigResult> createBackendConfigAsync(CreateBackendConfigRequest request, final AsyncHandler<CreateBackendConfigRequest, CreateBackendConfigResult> asyncHandler) {
        final CreateBackendConfigRequest finalRequest = (CreateBackendConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackendConfigResult>(){

            @Override
            public CreateBackendConfigResult call() throws Exception {
                CreateBackendConfigResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCreateBackendConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request) {
        return this.createTokenAsync(request, null);
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request, final AsyncHandler<CreateTokenRequest, CreateTokenResult> asyncHandler) {
        final CreateTokenRequest finalRequest = (CreateTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTokenResult>(){

            @Override
            public CreateTokenResult call() throws Exception {
                CreateTokenResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeCreateToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackendResult> deleteBackendAsync(DeleteBackendRequest request) {
        return this.deleteBackendAsync(request, null);
    }

    @Override
    public Future<DeleteBackendResult> deleteBackendAsync(DeleteBackendRequest request, final AsyncHandler<DeleteBackendRequest, DeleteBackendResult> asyncHandler) {
        final DeleteBackendRequest finalRequest = (DeleteBackendRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackendResult>(){

            @Override
            public DeleteBackendResult call() throws Exception {
                DeleteBackendResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeDeleteBackend(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackendAPIResult> deleteBackendAPIAsync(DeleteBackendAPIRequest request) {
        return this.deleteBackendAPIAsync(request, null);
    }

    @Override
    public Future<DeleteBackendAPIResult> deleteBackendAPIAsync(DeleteBackendAPIRequest request, final AsyncHandler<DeleteBackendAPIRequest, DeleteBackendAPIResult> asyncHandler) {
        final DeleteBackendAPIRequest finalRequest = (DeleteBackendAPIRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackendAPIResult>(){

            @Override
            public DeleteBackendAPIResult call() throws Exception {
                DeleteBackendAPIResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeDeleteBackendAPI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackendAuthResult> deleteBackendAuthAsync(DeleteBackendAuthRequest request) {
        return this.deleteBackendAuthAsync(request, null);
    }

    @Override
    public Future<DeleteBackendAuthResult> deleteBackendAuthAsync(DeleteBackendAuthRequest request, final AsyncHandler<DeleteBackendAuthRequest, DeleteBackendAuthResult> asyncHandler) {
        final DeleteBackendAuthRequest finalRequest = (DeleteBackendAuthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackendAuthResult>(){

            @Override
            public DeleteBackendAuthResult call() throws Exception {
                DeleteBackendAuthResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeDeleteBackendAuth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request) {
        return this.deleteTokenAsync(request, null);
    }

    @Override
    public Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request, final AsyncHandler<DeleteTokenRequest, DeleteTokenResult> asyncHandler) {
        final DeleteTokenRequest finalRequest = (DeleteTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTokenResult>(){

            @Override
            public DeleteTokenResult call() throws Exception {
                DeleteTokenResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeDeleteToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateBackendAPIModelsResult> generateBackendAPIModelsAsync(GenerateBackendAPIModelsRequest request) {
        return this.generateBackendAPIModelsAsync(request, null);
    }

    @Override
    public Future<GenerateBackendAPIModelsResult> generateBackendAPIModelsAsync(GenerateBackendAPIModelsRequest request, final AsyncHandler<GenerateBackendAPIModelsRequest, GenerateBackendAPIModelsResult> asyncHandler) {
        final GenerateBackendAPIModelsRequest finalRequest = (GenerateBackendAPIModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GenerateBackendAPIModelsResult>(){

            @Override
            public GenerateBackendAPIModelsResult call() throws Exception {
                GenerateBackendAPIModelsResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGenerateBackendAPIModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBackendResult> getBackendAsync(GetBackendRequest request) {
        return this.getBackendAsync(request, null);
    }

    @Override
    public Future<GetBackendResult> getBackendAsync(GetBackendRequest request, final AsyncHandler<GetBackendRequest, GetBackendResult> asyncHandler) {
        final GetBackendRequest finalRequest = (GetBackendRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBackendResult>(){

            @Override
            public GetBackendResult call() throws Exception {
                GetBackendResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetBackend(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBackendAPIResult> getBackendAPIAsync(GetBackendAPIRequest request) {
        return this.getBackendAPIAsync(request, null);
    }

    @Override
    public Future<GetBackendAPIResult> getBackendAPIAsync(GetBackendAPIRequest request, final AsyncHandler<GetBackendAPIRequest, GetBackendAPIResult> asyncHandler) {
        final GetBackendAPIRequest finalRequest = (GetBackendAPIRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBackendAPIResult>(){

            @Override
            public GetBackendAPIResult call() throws Exception {
                GetBackendAPIResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetBackendAPI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBackendAPIModelsResult> getBackendAPIModelsAsync(GetBackendAPIModelsRequest request) {
        return this.getBackendAPIModelsAsync(request, null);
    }

    @Override
    public Future<GetBackendAPIModelsResult> getBackendAPIModelsAsync(GetBackendAPIModelsRequest request, final AsyncHandler<GetBackendAPIModelsRequest, GetBackendAPIModelsResult> asyncHandler) {
        final GetBackendAPIModelsRequest finalRequest = (GetBackendAPIModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBackendAPIModelsResult>(){

            @Override
            public GetBackendAPIModelsResult call() throws Exception {
                GetBackendAPIModelsResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetBackendAPIModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBackendAuthResult> getBackendAuthAsync(GetBackendAuthRequest request) {
        return this.getBackendAuthAsync(request, null);
    }

    @Override
    public Future<GetBackendAuthResult> getBackendAuthAsync(GetBackendAuthRequest request, final AsyncHandler<GetBackendAuthRequest, GetBackendAuthResult> asyncHandler) {
        final GetBackendAuthRequest finalRequest = (GetBackendAuthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBackendAuthResult>(){

            @Override
            public GetBackendAuthResult call() throws Exception {
                GetBackendAuthResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetBackendAuth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBackendJobResult> getBackendJobAsync(GetBackendJobRequest request) {
        return this.getBackendJobAsync(request, null);
    }

    @Override
    public Future<GetBackendJobResult> getBackendJobAsync(GetBackendJobRequest request, final AsyncHandler<GetBackendJobRequest, GetBackendJobResult> asyncHandler) {
        final GetBackendJobRequest finalRequest = (GetBackendJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBackendJobResult>(){

            @Override
            public GetBackendJobResult call() throws Exception {
                GetBackendJobResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetBackendJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTokenResult> getTokenAsync(GetTokenRequest request) {
        return this.getTokenAsync(request, null);
    }

    @Override
    public Future<GetTokenResult> getTokenAsync(GetTokenRequest request, final AsyncHandler<GetTokenRequest, GetTokenResult> asyncHandler) {
        final GetTokenRequest finalRequest = (GetTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTokenResult>(){

            @Override
            public GetTokenResult call() throws Exception {
                GetTokenResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeGetToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBackendJobsResult> listBackendJobsAsync(ListBackendJobsRequest request) {
        return this.listBackendJobsAsync(request, null);
    }

    @Override
    public Future<ListBackendJobsResult> listBackendJobsAsync(ListBackendJobsRequest request, final AsyncHandler<ListBackendJobsRequest, ListBackendJobsResult> asyncHandler) {
        final ListBackendJobsRequest finalRequest = (ListBackendJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBackendJobsResult>(){

            @Override
            public ListBackendJobsResult call() throws Exception {
                ListBackendJobsResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeListBackendJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveAllBackendsResult> removeAllBackendsAsync(RemoveAllBackendsRequest request) {
        return this.removeAllBackendsAsync(request, null);
    }

    @Override
    public Future<RemoveAllBackendsResult> removeAllBackendsAsync(RemoveAllBackendsRequest request, final AsyncHandler<RemoveAllBackendsRequest, RemoveAllBackendsResult> asyncHandler) {
        final RemoveAllBackendsRequest finalRequest = (RemoveAllBackendsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveAllBackendsResult>(){

            @Override
            public RemoveAllBackendsResult call() throws Exception {
                RemoveAllBackendsResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeRemoveAllBackends(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveBackendConfigResult> removeBackendConfigAsync(RemoveBackendConfigRequest request) {
        return this.removeBackendConfigAsync(request, null);
    }

    @Override
    public Future<RemoveBackendConfigResult> removeBackendConfigAsync(RemoveBackendConfigRequest request, final AsyncHandler<RemoveBackendConfigRequest, RemoveBackendConfigResult> asyncHandler) {
        final RemoveBackendConfigRequest finalRequest = (RemoveBackendConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveBackendConfigResult>(){

            @Override
            public RemoveBackendConfigResult call() throws Exception {
                RemoveBackendConfigResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeRemoveBackendConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBackendAPIResult> updateBackendAPIAsync(UpdateBackendAPIRequest request) {
        return this.updateBackendAPIAsync(request, null);
    }

    @Override
    public Future<UpdateBackendAPIResult> updateBackendAPIAsync(UpdateBackendAPIRequest request, final AsyncHandler<UpdateBackendAPIRequest, UpdateBackendAPIResult> asyncHandler) {
        final UpdateBackendAPIRequest finalRequest = (UpdateBackendAPIRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBackendAPIResult>(){

            @Override
            public UpdateBackendAPIResult call() throws Exception {
                UpdateBackendAPIResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeUpdateBackendAPI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBackendAuthResult> updateBackendAuthAsync(UpdateBackendAuthRequest request) {
        return this.updateBackendAuthAsync(request, null);
    }

    @Override
    public Future<UpdateBackendAuthResult> updateBackendAuthAsync(UpdateBackendAuthRequest request, final AsyncHandler<UpdateBackendAuthRequest, UpdateBackendAuthResult> asyncHandler) {
        final UpdateBackendAuthRequest finalRequest = (UpdateBackendAuthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBackendAuthResult>(){

            @Override
            public UpdateBackendAuthResult call() throws Exception {
                UpdateBackendAuthResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeUpdateBackendAuth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBackendConfigResult> updateBackendConfigAsync(UpdateBackendConfigRequest request) {
        return this.updateBackendConfigAsync(request, null);
    }

    @Override
    public Future<UpdateBackendConfigResult> updateBackendConfigAsync(UpdateBackendConfigRequest request, final AsyncHandler<UpdateBackendConfigRequest, UpdateBackendConfigResult> asyncHandler) {
        final UpdateBackendConfigRequest finalRequest = (UpdateBackendConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBackendConfigResult>(){

            @Override
            public UpdateBackendConfigResult call() throws Exception {
                UpdateBackendConfigResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeUpdateBackendConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBackendJobResult> updateBackendJobAsync(UpdateBackendJobRequest request) {
        return this.updateBackendJobAsync(request, null);
    }

    @Override
    public Future<UpdateBackendJobResult> updateBackendJobAsync(UpdateBackendJobRequest request, final AsyncHandler<UpdateBackendJobRequest, UpdateBackendJobResult> asyncHandler) {
        final UpdateBackendJobRequest finalRequest = (UpdateBackendJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBackendJobResult>(){

            @Override
            public UpdateBackendJobResult call() throws Exception {
                UpdateBackendJobResult result = null;
                try {
                    result = AWSAmplifyBackendAsyncClient.this.executeUpdateBackendJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

