/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifybackend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifybackend.model.MfaTypesElement;
import com.amazonaws.services.amplifybackend.model.transform.SettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Settings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> mfaTypes;
    private String smsMessage;

    public List<String> getMfaTypes() {
        return this.mfaTypes;
    }

    public void setMfaTypes(Collection<String> mfaTypes) {
        if (mfaTypes == null) {
            this.mfaTypes = null;
            return;
        }
        this.mfaTypes = new ArrayList<String>(mfaTypes);
    }

    public Settings withMfaTypes(String ... mfaTypes) {
        if (this.mfaTypes == null) {
            this.setMfaTypes(new ArrayList<String>(mfaTypes.length));
        }
        for (String ele : mfaTypes) {
            this.mfaTypes.add(ele);
        }
        return this;
    }

    public Settings withMfaTypes(Collection<String> mfaTypes) {
        this.setMfaTypes(mfaTypes);
        return this;
    }

    public Settings withMfaTypes(MfaTypesElement ... mfaTypes) {
        ArrayList<String> mfaTypesCopy = new ArrayList<String>(mfaTypes.length);
        for (MfaTypesElement value : mfaTypes) {
            mfaTypesCopy.add(value.toString());
        }
        if (this.getMfaTypes() == null) {
            this.setMfaTypes(mfaTypesCopy);
        } else {
            this.getMfaTypes().addAll(mfaTypesCopy);
        }
        return this;
    }

    public void setSmsMessage(String smsMessage) {
        this.smsMessage = smsMessage;
    }

    public String getSmsMessage() {
        return this.smsMessage;
    }

    public Settings withSmsMessage(String smsMessage) {
        this.setSmsMessage(smsMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMfaTypes() != null) {
            sb.append("MfaTypes: ").append(this.getMfaTypes()).append(",");
        }
        if (this.getSmsMessage() != null) {
            sb.append("SmsMessage: ").append(this.getSmsMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        if (other.getMfaTypes() == null ^ this.getMfaTypes() == null) {
            return false;
        }
        if (other.getMfaTypes() != null && !other.getMfaTypes().equals(this.getMfaTypes())) {
            return false;
        }
        if (other.getSmsMessage() == null ^ this.getSmsMessage() == null) {
            return false;
        }
        return other.getSmsMessage() == null || other.getSmsMessage().equals(this.getSmsMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMfaTypes() == null ? 0 : this.getMfaTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsMessage() == null ? 0 : this.getSmsMessage().hashCode());
        return hashCode;
    }

    public Settings clone() {
        try {
            return (Settings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

