/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.amplify.model.Branch;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class BranchMarshaller {
    private static final MarshallingInfo<String> BRANCHARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("branchArn").build();
    private static final MarshallingInfo<String> BRANCHNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("branchName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> STAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stage").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").build();
    private static final MarshallingInfo<Boolean> ENABLENOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enableNotification").build();
    private static final MarshallingInfo<Date> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> ENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariables").build();
    private static final MarshallingInfo<Boolean> ENABLEAUTOBUILD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enableAutoBuild").build();
    private static final MarshallingInfo<List> CUSTOMDOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customDomains").build();
    private static final MarshallingInfo<String> FRAMEWORK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framework").build();
    private static final MarshallingInfo<String> ACTIVEJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeJobId").build();
    private static final MarshallingInfo<String> TOTALNUMBEROFJOBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalNumberOfJobs").build();
    private static final MarshallingInfo<Boolean> ENABLEBASICAUTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enableBasicAuth").build();
    private static final MarshallingInfo<String> THUMBNAILURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thumbnailUrl").build();
    private static final MarshallingInfo<String> BASICAUTHCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("basicAuthCredentials").build();
    private static final MarshallingInfo<String> BUILDSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buildSpec").build();
    private static final MarshallingInfo<String> TTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ttl").build();
    private static final MarshallingInfo<List> ASSOCIATEDRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("associatedResources").build();
    private static final BranchMarshaller instance = new BranchMarshaller();

    public static BranchMarshaller getInstance() {
        return instance;
    }

    public void marshall(Branch branch, ProtocolMarshaller protocolMarshaller) {
        if (branch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)branch.getBranchArn(), BRANCHARN_BINDING);
            protocolMarshaller.marshall((Object)branch.getBranchName(), BRANCHNAME_BINDING);
            protocolMarshaller.marshall((Object)branch.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(branch.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)branch.getStage(), STAGE_BINDING);
            protocolMarshaller.marshall((Object)branch.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)branch.getEnableNotification(), ENABLENOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)branch.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)branch.getUpdateTime(), UPDATETIME_BINDING);
            protocolMarshaller.marshall(branch.getEnvironmentVariables(), ENVIRONMENTVARIABLES_BINDING);
            protocolMarshaller.marshall((Object)branch.getEnableAutoBuild(), ENABLEAUTOBUILD_BINDING);
            protocolMarshaller.marshall(branch.getCustomDomains(), CUSTOMDOMAINS_BINDING);
            protocolMarshaller.marshall((Object)branch.getFramework(), FRAMEWORK_BINDING);
            protocolMarshaller.marshall((Object)branch.getActiveJobId(), ACTIVEJOBID_BINDING);
            protocolMarshaller.marshall((Object)branch.getTotalNumberOfJobs(), TOTALNUMBEROFJOBS_BINDING);
            protocolMarshaller.marshall((Object)branch.getEnableBasicAuth(), ENABLEBASICAUTH_BINDING);
            protocolMarshaller.marshall((Object)branch.getThumbnailUrl(), THUMBNAILURL_BINDING);
            protocolMarshaller.marshall((Object)branch.getBasicAuthCredentials(), BASICAUTHCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)branch.getBuildSpec(), BUILDSPEC_BINDING);
            protocolMarshaller.marshall((Object)branch.getTtl(), TTL_BINDING);
            protocolMarshaller.marshall(branch.getAssociatedResources(), ASSOCIATEDRESOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

