/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.alexaforbusiness.model.DeviceData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchDevicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DeviceData> devices;
    private String nextToken;
    private Integer totalCount;

    public List<DeviceData> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<DeviceData> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<DeviceData>(devices);
    }

    public SearchDevicesResult withDevices(DeviceData ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<DeviceData>(devices.length));
        }
        for (DeviceData ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public SearchDevicesResult withDevices(Collection<DeviceData> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchDevicesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public SearchDevicesResult withTotalCount(Integer totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDevicesResult)) {
            return false;
        }
        SearchDevicesResult other = (SearchDevicesResult)obj;
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SearchDevicesResult clone() {
        try {
            return (SearchDevicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

