/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.alexaforbusiness.model.DeviceEventType;
import com.amazonaws.services.alexaforbusiness.model.transform.DeviceEventMarshaller;
import java.io.Serializable;
import java.util.Date;

public class DeviceEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String value;
    private Date timestamp;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DeviceEvent withType(String type) {
        this.setType(type);
        return this;
    }

    public DeviceEvent withType(DeviceEventType type) {
        this.type = type.toString();
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public DeviceEvent withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public DeviceEvent withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public DeviceEvent clone() {
        try {
            return (DeviceEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

