/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.ImportCertificateRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ImportCertificateRequestMarshaller
implements Marshaller<Request<ImportCertificateRequest>, ImportCertificateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ImportCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ImportCertificateRequest> marshall(ImportCertificateRequest importCertificateRequest) {
        if (importCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importCertificateRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.ImportCertificate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (importCertificateRequest.getCertificateArn() != null) {
                jsonGenerator.writeFieldName("CertificateArn").writeValue(importCertificateRequest.getCertificateArn());
            }
            if (importCertificateRequest.getCertificate() != null) {
                jsonGenerator.writeFieldName("Certificate").writeValue(importCertificateRequest.getCertificate());
            }
            if (importCertificateRequest.getPrivateKey() != null) {
                jsonGenerator.writeFieldName("PrivateKey").writeValue(importCertificateRequest.getPrivateKey());
            }
            if (importCertificateRequest.getCertificateChain() != null) {
                jsonGenerator.writeFieldName("CertificateChain").writeValue(importCertificateRequest.getCertificateChain());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

